/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.joynr.accesscontrol.DomainRoleEntryStore;
import io.joynr.accesscontrol.datatype.OwnerRegistrationControlEntryDB;
import java.util.ArrayList;
import java.util.List;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnerRegistrationControlEntryStore {
    private static final String WILDCARD = "*";
    private static final Logger logger = LoggerFactory.getLogger(OwnerRegistrationControlEntryStore.class);
    private DomainRoleEntryStore domainRoleEntryStore;
    private IndexedCollection<OwnerRegistrationControlEntryDB> ownerRclDB = new ConcurrentIndexedCollection();

    public OwnerRegistrationControlEntryStore(DomainRoleEntryStore domainRoleEntryStore) {
        this.domainRoleEntryStore = domainRoleEntryStore;
        this.ownerRclDB.addIndex((Index)HashIndex.onAttribute(OwnerRegistrationControlEntryDB.UID));
        this.ownerRclDB.addIndex((Index)HashIndex.onAttribute(OwnerRegistrationControlEntryDB.INTERFACENAME));
        this.ownerRclDB.addIndex((Index)HashIndex.onAttribute(OwnerRegistrationControlEntryDB.DOMAIN));
    }

    public List<OwnerRegistrationControlEntry> getControlEntries(String uid) {
        ArrayList<OwnerRegistrationControlEntry> controlEntries = new ArrayList<OwnerRegistrationControlEntry>();
        Equal cqQuery = QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)uid);
        this.ownerRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerRegistrationControlEntry()));
        if (controlEntries.isEmpty()) {
            Equal cqQueryWildcard = QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)WILDCARD);
            this.ownerRclDB.retrieve((Query)cqQueryWildcard).forEach(result -> controlEntries.add(result.getOwnerRegistrationControlEntry()));
        }
        return controlEntries;
    }

    public List<OwnerRegistrationControlEntry> getEditableAces(String uid, Role role) {
        ArrayList<OwnerRegistrationControlEntry> controlEntries = new ArrayList<OwnerRegistrationControlEntry>();
        DomainRoleEntry domainRoleEntry = this.domainRoleEntryStore.getDomainRole(uid, role);
        if (domainRoleEntry == null) {
            return controlEntries;
        }
        if (domainRoleEntry.getDomains().length == 0) {
            return controlEntries;
        }
        for (String domain : domainRoleEntry.getDomains()) {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.DOMAIN, (Object)domain));
            this.ownerRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerRegistrationControlEntry()));
        }
        return controlEntries;
    }

    public List<OwnerRegistrationControlEntry> getControlEntries(String domain, String interfaceName) {
        ArrayList<OwnerRegistrationControlEntry> controlEntries = new ArrayList<OwnerRegistrationControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
        this.ownerRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerRegistrationControlEntry()));
        return controlEntries;
    }

    public OwnerRegistrationControlEntry getControlEntry(String uid, String domain, String interfaceName) {
        OwnerRegistrationControlEntry ownerRce = null;
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
        ResultSet cqResult = this.ownerRclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(OwnerRegistrationControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            ownerRce = ((OwnerRegistrationControlEntryDB)((Object)cqResult.uniqueResult())).getOwnerRegistrationControlEntry();
        }
        return ownerRce;
    }

    public Boolean updateControlEntry(OwnerRegistrationControlEntry updatedMasterAce) {
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)updatedMasterAce.getUid()), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.DOMAIN, (Object)updatedMasterAce.getDomain()), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.INTERFACENAME, (Object)updatedMasterAce.getInterfaceName()));
        ResultSet cqResult = this.ownerRclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(OwnerRegistrationControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            this.ownerRclDB.remove(cqResult.uniqueResult());
        }
        return this.ownerRclDB.add((Object)new OwnerRegistrationControlEntryDB(updatedMasterAce));
    }

    public boolean removeControlEntry(String uid, String domain, String interfaceName) {
        boolean removeResult = false;
        try {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
            removeResult = this.ownerRclDB.update((Iterable)this.ownerRclDB.retrieve((Query)cqQuery), new ArrayList());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("Remove masterAcl failed.", (Throwable)e);
        }
        return removeResult;
    }
}

