/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.exceptions.JoynrCommunicationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryEntryStoreInMemory<T extends DiscoveryEntry>
implements DiscoveryEntryStore<T> {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryEntryStoreInMemory.class);
    Map<String, Long> registeredCapabilitiesTime = new HashMap<String, Long>();
    Map<String, List<String>> interfaceAddressToCapabilityMapping = new HashMap<String, List<String>>();
    Map<String, String> participantIdToCapabilityMapping = new HashMap<String, String>();
    Map<String, T> capabilityKeyToCapabilityMapping = new HashMap<String, T>();
    TreeMap<Long, String> queueIdToParticipantIdMapping = new TreeMap();
    Map<String, Long> participantIdToQueueIdMapping = new HashMap<String, Long>();
    private long counter = 0L;
    private int maximumNumberOfNonStickyEntries;
    private Object storeLock = new Object();

    public DiscoveryEntryStoreInMemory(int maximumNumberOfNonStickyEntries) {
        logger.info("Creating CapabilitiesStore, maximumNumberOfNonStickyEntries = {}", (Object)maximumNumberOfNonStickyEntries);
        this.maximumNumberOfNonStickyEntries = maximumNumberOfNonStickyEntries;
    }

    private void recreateQueueIdToParticipantIdMapping() {
        TreeMap<Long, String> newMap = new TreeMap<Long, String>();
        this.participantIdToQueueIdMapping = new HashMap<String, Long>();
        this.counter = 0L;
        for (String participantId : this.queueIdToParticipantIdMapping.values()) {
            ++this.counter;
            newMap.put(this.counter, participantId);
            this.participantIdToQueueIdMapping.put(participantId, this.counter);
        }
        ++this.counter;
        this.queueIdToParticipantIdMapping = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T discoveryEntry) {
        if (discoveryEntry == null || discoveryEntry.getDomain() == null || discoveryEntry.getInterfaceName() == null || discoveryEntry.getParticipantId() == null) {
            String message = String.format("Entry being registered is null or not complete: %s", discoveryEntry);
            logger.error(message);
            throw new JoynrCommunicationException(message);
        }
        String participantId = discoveryEntry.getParticipantId();
        logger.trace("About to add entry for participantId {} to DiscoveryEntryStoreInMemory.", (Object)participantId);
        Object object = this.storeLock;
        synchronized (object) {
            ArrayList<String> newMapping;
            String domainInterfaceId;
            ArrayList<String> mapping;
            DiscoveryEntry oldDiscoveryEntry;
            long newTimeMs;
            Long oldTimeMs;
            String discoveryEntryId;
            String oldDiscoveryEntryId;
            boolean removedSuccessfully = this.removeDiscoveryEntryFromStore(participantId);
            if (removedSuccessfully) {
                logger.trace("Removed old entry for participantId {} from DiscoveryEntryStoreInMemory.", (Object)participantId);
            }
            if (this.maximumNumberOfNonStickyEntries > 0 && discoveryEntry.getExpiryDateMs() != Long.MAX_VALUE) {
                Long oldQueueId;
                String oldParticipantId;
                if (this.queueIdToParticipantIdMapping.size() >= this.maximumNumberOfNonStickyEntries) {
                    Map.Entry<Long, String> entry = this.queueIdToParticipantIdMapping.firstEntry();
                    String oldestParticipantId = entry.getValue();
                    removedSuccessfully = this.removeDiscoveryEntryFromStore(oldestParticipantId);
                    if (removedSuccessfully) {
                        logger.debug("Removed oldest entry for participantId {}, queueId {} from DiscoveryEntryStoreInMemory.", (Object)oldestParticipantId, (Object)entry.getKey());
                    } else {
                        logger.error("Could not remove oldest entry with participantId {}, queueId {} from DiscoveryEntryStoreInMemory.", (Object)oldestParticipantId, (Object)entry.getKey());
                    }
                }
                ++this.counter;
                if (Long.MAX_VALUE == this.counter) {
                    this.recreateQueueIdToParticipantIdMapping();
                }
                if ((oldParticipantId = this.queueIdToParticipantIdMapping.put(this.counter, participantId)) != null) {
                    logger.error("Found existing entry queueId {} in queueIdToParticipantIdMapping, old participantId {}, new participantId {}", new Object[]{this.counter, oldParticipantId, participantId});
                }
                if ((oldQueueId = this.participantIdToQueueIdMapping.put(participantId, this.counter)) != null) {
                    logger.error("Found existing entry participantId {} in participantIdToQueueIdMapping, old queueId {}, new queueId {}", new Object[]{participantId, oldQueueId, this.counter});
                }
            }
            if ((oldDiscoveryEntryId = this.participantIdToCapabilityMapping.put(participantId, discoveryEntryId = this.domainInterfaceParticipantIdKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName(), participantId))) != null) {
                logger.error("Found existing entry participantId {} in participantIdToCapabilityMapping, old discoveryEntryId {}, new discoveryEntryId {}", new Object[]{participantId, oldDiscoveryEntryId, discoveryEntryId});
            }
            if ((oldTimeMs = this.registeredCapabilitiesTime.put(discoveryEntryId, newTimeMs = System.currentTimeMillis())) != null) {
                logger.error("Found existing entry discoveryEntryId {} in registeredCapabilitiesTime, old timeMs {}, new timeMs {}", new Object[]{discoveryEntryId, oldTimeMs, newTimeMs});
            }
            if ((oldDiscoveryEntry = (DiscoveryEntry)this.capabilityKeyToCapabilityMapping.put(discoveryEntryId, discoveryEntry)) != null) {
                logger.error("Found existing entry discoveryEntryId {} in capabilityKeyToCapabilityMapping, old discoveryEntry {}, new discoveryEntry {}", new Object[]{discoveryEntryId, oldDiscoveryEntry, discoveryEntry});
            }
            if ((mapping = (ArrayList<String>)this.interfaceAddressToCapabilityMapping.putIfAbsent(domainInterfaceId = this.domainInterfaceKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName()), newMapping = new ArrayList<String>())) == null) {
                mapping = newMapping;
            }
            mapping.add(discoveryEntryId);
            logger.debug("Added entry for participantId {} to DiscoveryEntryStoreInMemory.", (Object)participantId);
        }
    }

    public void add(Collection<T> entries) {
        if (entries != null) {
            for (DiscoveryEntry entry : entries) {
                this.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String participantId) {
        boolean removedSuccessfully = false;
        Object object = this.storeLock;
        synchronized (object) {
            removedSuccessfully = this.removeDiscoveryEntryFromStore(participantId);
        }
        if (!removedSuccessfully) {
            logger.error("Could not remove discoveryEntry for participantId {} from DiscoveryEntryStoreInMemory.", (Object)participantId);
        } else {
            logger.debug("Removed entry for participantId {} from DiscoveryEntryStoreInMemory.", (Object)participantId);
        }
        return removedSuccessfully;
    }

    private boolean removeDiscoveryEntryFromStore(String participantId) {
        DiscoveryEntry capability;
        logger.trace("removeDiscoveryEntryFromStore for participantId {}", (Object)participantId);
        String discoveryEntryId = this.participantIdToCapabilityMapping.remove(participantId);
        if (discoveryEntryId == null) {
            return false;
        }
        if (this.registeredCapabilitiesTime.remove(discoveryEntryId) == null) {
            logger.error("Could not find participantId {} to remove from registeredCapabilitiesTime, discoveryEntryId {}", (Object)participantId, (Object)discoveryEntryId);
        }
        if ((capability = (DiscoveryEntry)this.capabilityKeyToCapabilityMapping.remove(discoveryEntryId)) == null) {
            Long queueId;
            logger.error("Could not find discoveryEntryId {} to remove from capabilityKeyToCapabilityMapping", (Object)discoveryEntryId);
            if (this.maximumNumberOfNonStickyEntries > 0 && (queueId = this.participantIdToQueueIdMapping.remove(participantId)) != null) {
                this.queueIdToParticipantIdMapping.remove(queueId);
            }
            return false;
        }
        boolean removedSuccessfully = true;
        String domainInterfaceId = this.domainInterfaceKey(capability.getDomain(), capability.getInterfaceName());
        List<String> mapping = this.interfaceAddressToCapabilityMapping.get(domainInterfaceId);
        if (mapping != null) {
            if (!mapping.remove(discoveryEntryId)) {
                logger.error("Could not find discoveryEntryId {} to remove from list returned for domainInterfaceId {} in interfaceDomainToCapabilityMapping", (Object)discoveryEntryId, (Object)domainInterfaceId);
                removedSuccessfully = false;
            }
            if (mapping.isEmpty()) {
                this.interfaceAddressToCapabilityMapping.remove(domainInterfaceId);
            }
        } else {
            logger.error("Could not find domainInterfaceId {} in interfaceAddressToCapabilityMapping, in order to remove discoveryEntryId {} from associated list", (Object)domainInterfaceId, (Object)discoveryEntryId);
            removedSuccessfully = false;
        }
        if (this.maximumNumberOfNonStickyEntries > 0 && capability.getExpiryDateMs() != Long.MAX_VALUE) {
            Long queueId = this.participantIdToQueueIdMapping.remove(participantId);
            if (queueId == null) {
                logger.error("Could not find participantId {} to remove from participantIdToQueueIdMapping, discoveryEntryId {}", (Object)participantId, (Object)discoveryEntryId);
                removedSuccessfully = false;
            } else if (this.queueIdToParticipantIdMapping.remove(queueId) == null) {
                logger.error("Could not find queueid {} to remove from queueIdToParticipantIdMapping, discoveryEntryId {}", (Object)queueId, (Object)discoveryEntryId);
                removedSuccessfully = false;
            }
        }
        return removedSuccessfully;
    }

    public void remove(Collection<String> participantIds) {
        for (String participantId : participantIds) {
            this.remove(participantId);
        }
    }

    public Collection<T> lookup(String[] domains, String interfaceName) {
        return this.lookup(domains, interfaceName, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> lookup(String[] domains, String interfaceName, long cacheMaxAge) {
        ArrayList<DiscoveryEntry> capabilitiesList = new ArrayList<DiscoveryEntry>();
        Object object = this.storeLock;
        synchronized (object) {
            for (String domain : domains) {
                String domainInterfacekey = this.domainInterfaceKey(domain, interfaceName);
                List<String> matchingDiscoveryEntries = this.interfaceAddressToCapabilityMapping.get(domainInterfacekey);
                if (matchingDiscoveryEntries == null) continue;
                for (String capId : matchingDiscoveryEntries) {
                    DiscoveryEntry discoveryEntry = (DiscoveryEntry)this.capabilityKeyToCapabilityMapping.get(capId);
                    if (discoveryEntry instanceof GlobalDiscoveryEntry && !this.checkAge(this.registeredCapabilitiesTime.get(capId), cacheMaxAge)) continue;
                    capabilitiesList.add(discoveryEntry);
                }
            }
        }
        logger.trace("Capabilities found: {}", (Object)capabilitiesList.toString());
        return capabilitiesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> lookup(String participantId, long cacheMaxAge) {
        Object object = this.storeLock;
        synchronized (object) {
            String discoveryEntryId = this.participantIdToCapabilityMapping.get(participantId);
            if (discoveryEntryId == null) {
                return Optional.empty();
            }
            DiscoveryEntry discoveryEntry = (DiscoveryEntry)this.capabilityKeyToCapabilityMapping.get(discoveryEntryId);
            logger.trace("Capability for participantId {} found: {}", (Object)participantId, (Object)discoveryEntry);
            if (discoveryEntry instanceof GlobalDiscoveryEntry && !this.checkAge(this.registeredCapabilitiesTime.get(discoveryEntryId), cacheMaxAge)) {
                return Optional.empty();
            }
            return Optional.of(discoveryEntry);
        }
    }

    public Collection<T> lookupGlobalEntries(String[] domains, String interfaceName) {
        Collection<T> capabilitiesList = this.lookup(domains, interfaceName);
        HashSet<DiscoveryEntry> result = new HashSet<DiscoveryEntry>();
        for (DiscoveryEntry cap : capabilitiesList) {
            if (!cap.getQos().getScope().equals((Object)ProviderScope.GLOBAL)) continue;
            result.add(cap);
        }
        return result;
    }

    public HashSet<T> getAllDiscoveryEntries() {
        HashSet allDiscoveryEntries = new HashSet();
        return allDiscoveryEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<T> getAllGlobalEntries() {
        HashSet<DiscoveryEntry> allGlobalEntries = new HashSet<DiscoveryEntry>();
        Object object = this.storeLock;
        synchronized (object) {
            for (DiscoveryEntry discoveryEntry : this.capabilityKeyToCapabilityMapping.values()) {
                if (!discoveryEntry.getQos().getScope().equals((Object)ProviderScope.GLOBAL)) continue;
                allGlobalEntries.add(discoveryEntry);
            }
        }
        return allGlobalEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDiscoveryEntry(DiscoveryEntry discoveryEntry) {
        Object object = this.storeLock;
        synchronized (object) {
            String discoveryEntryId = this.domainInterfaceParticipantIdKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName(), discoveryEntry.getParticipantId());
            return this.registeredCapabilitiesTime.containsKey(discoveryEntryId);
        }
    }

    String domainInterfaceParticipantIdKey(String domain, String interfaceName, String participantId) {
        return (this.domainInterfaceKey(domain, interfaceName) + "|" + participantId).toLowerCase();
    }

    String domainInterfaceKey(String domain, String interfaceName) {
        return (domain + "|" + interfaceName).toLowerCase();
    }

    private boolean checkAge(Long timeStamp, long maxAcceptedAge) {
        return timeStamp != null && System.currentTimeMillis() - timeStamp <= maxAcceptedAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] touchDiscoveryEntries(long lastSeenDateMs, long expiryDateMs) {
        ArrayList<String> participantIds = new ArrayList<String>();
        Object object = this.storeLock;
        synchronized (object) {
            for (DiscoveryEntry discoveryEntry : this.capabilityKeyToCapabilityMapping.values()) {
                if (discoveryEntry.getLastSeenDateMs() < lastSeenDateMs) {
                    discoveryEntry.setLastSeenDateMs(Long.valueOf(lastSeenDateMs));
                }
                if (discoveryEntry.getExpiryDateMs() < expiryDateMs) {
                    discoveryEntry.setExpiryDateMs(Long.valueOf(expiryDateMs));
                }
                if (discoveryEntry.getQos().getScope() != ProviderScope.GLOBAL) continue;
                participantIds.add(discoveryEntry.getParticipantId());
            }
        }
        return participantIds.toArray(new String[participantIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchDiscoveryEntries(String[] participantIds, long lastSeenDateMs, long expiryDateMs) {
        Object object = this.storeLock;
        synchronized (object) {
            for (String participantId : participantIds) {
                String discoveryEntryId;
                DiscoveryEntry foundDiscoveryEntry;
                if (!this.participantIdToCapabilityMapping.containsKey(participantId) || (foundDiscoveryEntry = (DiscoveryEntry)this.capabilityKeyToCapabilityMapping.get(discoveryEntryId = this.participantIdToCapabilityMapping.get(participantId))) == null) continue;
                foundDiscoveryEntry.setLastSeenDateMs(Long.valueOf(lastSeenDateMs));
                foundDiscoveryEntry.setExpiryDateMs(Long.valueOf(expiryDateMs));
            }
        }
    }
}

