/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.google.inject.Inject;
import io.joynr.accesscontrol.AceValidator;
import io.joynr.accesscontrol.DomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.accesscontrol.primarykey.UserDomainInterfaceOperationKey;
import io.joynr.accesscontrol.primarykey.UserRoleKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import joynr.infrastructure.DacTypes.ControlEntry;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.Role;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Direction;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainAccessControlStoreEhCache
implements DomainAccessControlStore {
    private static final Logger logger = LoggerFactory.getLogger(DomainAccessControlStoreEhCache.class);
    private static final String WILDCARD = "*";
    private final CacheManager cacheManager;

    @Inject
    public DomainAccessControlStoreEhCache(CacheManager ehCacheManager, DomainAccessControlProvisioning domainAccessControlProvisioning) {
        this.cacheManager = ehCacheManager;
        Collection domainRoleEntries = domainAccessControlProvisioning.getDomainRoleEntries();
        for (DomainRoleEntry provisionedDomainRoleEntry : domainRoleEntries) {
            this.updateDomainRole(provisionedDomainRoleEntry);
        }
        Collection masterAccessControlEntries = domainAccessControlProvisioning.getMasterAccessControlEntries();
        for (MasterAccessControlEntry provisionedMasterAccessControlEntry : masterAccessControlEntries) {
            this.updateMasterAccessControlEntry(provisionedMasterAccessControlEntry);
        }
    }

    @Override
    public List<DomainRoleEntry> getDomainRoles(String uid) {
        Cache cache = this.getCache(CacheId.DOMAIN_ROLES);
        ArrayList<DomainRoleEntry> domainRoles = new ArrayList<DomainRoleEntry>();
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Query queryRequestedUid = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid)).includeKeys().end();
        Results results = queryRequestedUid.execute();
        for (Result result : results.all()) {
            domainRoles.add((DomainRoleEntry)DomainAccessControlStoreEhCache.getElementValue(cache.get(result.getKey())));
        }
        return domainRoles;
    }

    @Override
    public DomainRoleEntry getDomainRole(String uid, Role role) {
        Cache cache = this.getCache(CacheId.DOMAIN_ROLES);
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Attribute roleAttribute = cache.getSearchAttribute("role");
        Query queryRequestedUid = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid)).addCriteria(roleAttribute.eq((Object)role)).includeKeys().end();
        Results results = queryRequestedUid.execute();
        DomainRoleEntry domainRole = null;
        if (!results.all().isEmpty()) {
            assert (results.all().size() == 1);
            domainRole = (DomainRoleEntry)DomainAccessControlStoreEhCache.getElementValue(cache.get(((Result)results.all().get(0)).getKey()));
        }
        return domainRole;
    }

    @Override
    public Boolean updateDomainRole(@Nonnull DomainRoleEntry updatedEntry) {
        boolean updateSuccess = false;
        Cache cache = this.getCache(CacheId.DOMAIN_ROLES);
        UserRoleKey dreKey = new UserRoleKey(updatedEntry.getUid(), updatedEntry.getRole());
        try {
            cache.put(new Element((Serializable)dreKey, (Serializable)updatedEntry));
            updateSuccess = true;
        }
        catch (IllegalArgumentException | IllegalStateException | CacheException e) {
            logger.error("updateDomainRole failed.", e);
        }
        return updateSuccess;
    }

    @Override
    public Boolean removeDomainRole(String uid, Role role) {
        UserRoleKey dreKey = new UserRoleKey(uid, role);
        return this.removeAce(CacheId.DOMAIN_ROLES, dreKey);
    }

    @Override
    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String uid) {
        return this.getAces(uid, CacheId.MASTER_ACL);
    }

    @Override
    public List<MasterAccessControlEntry> getEditableMasterAccessControlEntries(String uid) {
        return this.getEditableAces(uid, CacheId.MASTER_ACL, Role.MASTER);
    }

    @Override
    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String domain, String interfaceName) {
        return this.getAces(domain, interfaceName, CacheId.MASTER_ACL);
    }

    @Override
    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.getAces(CacheId.MASTER_ACL, uid, domain, interfaceName);
    }

    @Override
    public MasterAccessControlEntry getMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry masterAce = (MasterAccessControlEntry)this.getAce(CacheId.MASTER_ACL, uid, domain, interfaceName, operation);
        if (masterAce == null) {
            masterAce = (MasterAccessControlEntry)this.getAce(CacheId.MASTER_ACL, uid, domain, interfaceName, WILDCARD);
        }
        return masterAce;
    }

    @Override
    public Boolean updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAce) {
        boolean updateSuccess = false;
        UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(updatedMasterAce.getUid(), updatedMasterAce.getDomain(), updatedMasterAce.getInterfaceName(), updatedMasterAce.getOperation());
        updateSuccess = this.updateAce(updatedMasterAce, CacheId.MASTER_ACL, aceKey);
        return updateSuccess;
    }

    @Override
    public Boolean removeMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(uid, domain, interfaceName, operation);
        return this.removeAce(CacheId.MASTER_ACL, aceKey);
    }

    @Override
    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String uid) {
        return this.getAces(uid, CacheId.MEDIATOR_ACL);
    }

    @Override
    public List<MasterAccessControlEntry> getEditableMediatorAccessControlEntries(String uid) {
        return this.getEditableAces(uid, CacheId.MEDIATOR_ACL, Role.MASTER);
    }

    @Override
    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String domain, String interfaceName) {
        return this.getAces(domain, interfaceName, CacheId.MEDIATOR_ACL);
    }

    @Override
    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.getAces(CacheId.MEDIATOR_ACL, uid, domain, interfaceName);
    }

    @Override
    public MasterAccessControlEntry getMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry mediatorAce = (MasterAccessControlEntry)this.getAce(CacheId.MEDIATOR_ACL, uid, domain, interfaceName, operation);
        if (mediatorAce == null) {
            mediatorAce = (MasterAccessControlEntry)this.getAce(CacheId.MEDIATOR_ACL, uid, domain, interfaceName, WILDCARD);
        }
        return mediatorAce;
    }

    @Override
    public Boolean updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAce) {
        boolean updateSuccess = false;
        MasterAccessControlEntry masterAce = this.getMasterAccessControlEntry(updatedMediatorAce.getUid(), updatedMediatorAce.getDomain(), updatedMediatorAce.getInterfaceName(), updatedMediatorAce.getOperation());
        AceValidator aceValidator = new AceValidator(masterAce, updatedMediatorAce, null);
        if (aceValidator.isMediatorValid()) {
            UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(updatedMediatorAce.getUid(), updatedMediatorAce.getDomain(), updatedMediatorAce.getInterfaceName(), updatedMediatorAce.getOperation());
            updateSuccess = this.updateAce(updatedMediatorAce, CacheId.MASTER_ACL, aceKey);
        }
        return updateSuccess;
    }

    @Override
    public Boolean removeMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(uid, domain, interfaceName, operation);
        return this.removeAce(CacheId.MEDIATOR_ACL, aceKey);
    }

    @Override
    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String uid) {
        return this.getAces(uid, CacheId.OWNER_ACL);
    }

    @Override
    public List<OwnerAccessControlEntry> getEditableOwnerAccessControlEntries(String uid) {
        return this.getEditableAces(uid, CacheId.OWNER_ACL, Role.OWNER);
    }

    @Override
    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String domain, String interfaceName) {
        return this.getAces(domain, interfaceName, CacheId.OWNER_ACL);
    }

    @Override
    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.getAces(CacheId.OWNER_ACL, uid, domain, interfaceName);
    }

    @Override
    public OwnerAccessControlEntry getOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        OwnerAccessControlEntry ownerAce = (OwnerAccessControlEntry)this.getAce(CacheId.OWNER_ACL, uid, domain, interfaceName, operation);
        if (ownerAce == null) {
            ownerAce = (OwnerAccessControlEntry)this.getAce(CacheId.OWNER_ACL, uid, domain, interfaceName, WILDCARD);
        }
        return ownerAce;
    }

    @Override
    public Boolean updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAce) {
        MasterAccessControlEntry mediatorAce;
        boolean updateSuccess = false;
        MasterAccessControlEntry masterAce = this.getMasterAccessControlEntry(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation());
        AceValidator aceValidator = new AceValidator(masterAce, mediatorAce = this.getMediatorAccessControlEntry(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation()), updatedOwnerAce);
        if (aceValidator.isOwnerValid()) {
            UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation());
            updateSuccess = this.updateAce(updatedOwnerAce, CacheId.OWNER_ACL, aceKey);
        }
        return updateSuccess;
    }

    @Override
    public Boolean removeOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        UserDomainInterfaceOperationKey aceKey = new UserDomainInterfaceOperationKey(uid, domain, interfaceName, operation);
        return this.removeAce(CacheId.OWNER_ACL, aceKey);
    }

    private <T extends ControlEntry> T getAce(CacheId cacheId, String uid, String domain, String interfaceName, String operation) {
        Cache cache = this.getCache(cacheId);
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Attribute domainAttribute = cache.getSearchAttribute("domain");
        Attribute interfaceAttribute = cache.getSearchAttribute("interfaceName");
        Attribute operationAttribute = cache.getSearchAttribute("operation");
        Query queryAllOperations = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid).or(uidAttribute.eq((Object)WILDCARD))).addCriteria(domainAttribute.eq((Object)domain)).addCriteria(interfaceAttribute.eq((Object)interfaceName)).addCriteria(operationAttribute.eq((Object)operation)).addOrderBy(uidAttribute, Direction.DESCENDING).includeKeys().end();
        Results results = queryAllOperations.execute();
        ControlEntry ace = null;
        if (!results.all().isEmpty()) {
            ace = (ControlEntry)DomainAccessControlStoreEhCache.getElementValue(cache.get(((Result)results.all().get(0)).getKey()));
        }
        return (T)ace;
    }

    private <T extends ControlEntry> List<T> getAces(String uid, CacheId cacheId) {
        Cache cache = this.getCache(cacheId);
        ArrayList<T> aces = new ArrayList<T>();
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Query queryRequestedUid = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid).or(uidAttribute.eq((Object)WILDCARD))).addOrderBy(uidAttribute, Direction.DESCENDING).includeKeys().end();
        Results results = queryRequestedUid.execute();
        for (Result result : results.all()) {
            aces.add(DomainAccessControlStoreEhCache.getElementValue(cache.get(result.getKey())));
        }
        return aces;
    }

    private <T extends ControlEntry> List<T> getAces(String domain, String interfaceName, CacheId cacheId) {
        Cache cache = this.getCache(cacheId);
        ArrayList<ControlEntry> aces = new ArrayList<ControlEntry>();
        Attribute domainAttribute = cache.getSearchAttribute("domain");
        Attribute interfaceAttribute = cache.getSearchAttribute("interfaceName");
        Query queryDomainInterface = cache.createQuery().addCriteria(domainAttribute.eq((Object)domain).and(interfaceAttribute.eq((Object)interfaceName))).includeKeys().end();
        Results results = queryDomainInterface.execute();
        for (Result result : results.all()) {
            ControlEntry ace = (ControlEntry)DomainAccessControlStoreEhCache.getElementValue(cache.get(result.getKey()));
            aces.add(ace);
        }
        return aces;
    }

    private <T extends ControlEntry> List<T> getAces(CacheId cacheId, String uid, String domain, String interfaceName) {
        Cache cache = this.getCache(cacheId);
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Attribute domainAttribute = cache.getSearchAttribute("domain");
        Attribute interfaceAttribute = cache.getSearchAttribute("interfaceName");
        Query queryAllOperations = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid).or(uidAttribute.eq((Object)WILDCARD))).addCriteria(domainAttribute.eq((Object)domain)).addCriteria(interfaceAttribute.eq((Object)interfaceName)).addOrderBy(uidAttribute, Direction.DESCENDING).includeKeys().end();
        Results results = queryAllOperations.execute();
        ArrayList<ControlEntry> aces = new ArrayList<ControlEntry>();
        String currentUid = null;
        for (Result result : results.all()) {
            ControlEntry ace = (ControlEntry)DomainAccessControlStoreEhCache.getElementValue(cache.get(result.getKey()));
            if (currentUid == null) {
                currentUid = ace.getUid();
            } else if (!currentUid.equals(ace.getUid())) break;
            aces.add(ace);
        }
        return aces;
    }

    private <T extends ControlEntry> List<T> getEditableAces(String uid, CacheId cacheId, Role role) {
        ArrayList<T> aces = new ArrayList<T>();
        Cache drtCache = this.getCache(CacheId.DOMAIN_ROLES);
        UserRoleKey dreKey = new UserRoleKey(uid, role);
        String[] uidDomains = null;
        if (drtCache.isKeyInCache((Object)dreKey)) {
            DomainRoleEntry dre = (DomainRoleEntry)DomainAccessControlStoreEhCache.getElementValue(drtCache.get((Serializable)dreKey));
            uidDomains = dre.getDomains();
        }
        if (uidDomains == null || uidDomains.length == 0) {
            return aces;
        }
        Cache cache = this.getCache(cacheId);
        Attribute uidAttribute = cache.getSearchAttribute("uid");
        Attribute domainAttribute = cache.getSearchAttribute("domain");
        for (String domain : uidDomains) {
            Query query = cache.createQuery().addCriteria(uidAttribute.eq((Object)uid).and(domainAttribute.eq((Object)domain))).includeKeys().end();
            Results results = query.execute();
            for (Result result : results.all()) {
                aces.add(DomainAccessControlStoreEhCache.getElementValue(cache.get(result.getKey())));
            }
        }
        return aces;
    }

    private <T extends ControlEntry> Boolean updateAce(T accessControlEntry, CacheId cacheId, Object aceKey) {
        Cache cache = this.getCache(cacheId);
        boolean updateSuccess = false;
        try {
            cache.put(new Element(aceKey, accessControlEntry));
            updateSuccess = true;
        }
        catch (IllegalArgumentException | IllegalStateException | CacheException e) {
            logger.error("update " + (Object)((Object)cacheId) + "failed.", e);
        }
        return updateSuccess;
    }

    private boolean removeAce(CacheId cacheId, Object aceKey) {
        Cache cache = this.getCache(cacheId);
        boolean removeResult = false;
        try {
            removeResult = cache.remove(aceKey);
        }
        catch (IllegalArgumentException | IllegalStateException | CacheException e) {
            logger.error("remove " + (Object)((Object)cacheId) + " failed.", e);
        }
        return removeResult;
    }

    protected Cache getCache(CacheId cacheId) {
        Cache cache = this.cacheManager.getCache(cacheId.getIdAsString());
        if (cache == null) {
            switch (cacheId) {
                case MASTER_ACL: 
                case MEDIATOR_ACL: 
                case OWNER_ACL: {
                    cache = this.createAclCache(cacheId);
                    break;
                }
                case DOMAIN_ROLES: {
                    cache = this.createDrtCache();
                    break;
                }
            }
        }
        return cache;
    }

    private Cache createAclCache(CacheId cacheId) {
        CacheConfiguration cacheConfig = new CacheConfiguration(cacheId.getIdAsString(), 0).eternal(true);
        Searchable searchable = new Searchable();
        cacheConfig.addSearchable(searchable);
        searchable.addSearchAttribute(new SearchAttribute().name("uid"));
        searchable.addSearchAttribute(new SearchAttribute().name("domain"));
        searchable.addSearchAttribute(new SearchAttribute().name("interfaceName"));
        searchable.addSearchAttribute(new SearchAttribute().name("operation"));
        this.cacheManager.addCache(new Cache(cacheConfig));
        return this.cacheManager.getCache(cacheId.getIdAsString());
    }

    private Cache createDrtCache() {
        CacheConfiguration cacheConfig = new CacheConfiguration(CacheId.DOMAIN_ROLES.getIdAsString(), 0).eternal(true);
        Searchable searchable = new Searchable();
        cacheConfig.addSearchable(searchable);
        searchable.addSearchAttribute(new SearchAttribute().name("uid"));
        searchable.addSearchAttribute(new SearchAttribute().name("role"));
        this.cacheManager.addCache(new Cache(cacheConfig));
        return this.cacheManager.getCache(CacheId.DOMAIN_ROLES.getIdAsString());
    }

    public static <T> T getElementValue(Element e) {
        return (T)e.getObjectValue();
    }

    public static enum CacheId {
        MASTER_ACL("io.joynr.MasterACL"),
        OWNER_ACL("io.joynr.OwnerACL"),
        MEDIATOR_ACL("io.joynr.MediatorACL"),
        DOMAIN_ROLES("io.joynr.DomainRoleTable");

        private final String idAsString;

        private CacheId(String id) {
            this.idAsString = id;
        }

        public String getIdAsString() {
            return this.idAsString;
        }
    }
}

