/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.collect.Lists;
import io.joynr.capabilities.CapabilityListener;
import io.joynr.capabilities.LocalCapabilitiesDirectory;
import java.util.List;
import joynr.system.DiscoveryAbstractProvider;
import joynr.types.DiscoveryEntry;

public abstract class AbstractLocalCapabilitiesDirectory
extends DiscoveryAbstractProvider
implements LocalCapabilitiesDirectory {
    List<CapabilityListener> capabilityListeners = Lists.newArrayList();

    @Override
    public void addCapabilityListener(CapabilityListener listener) {
        if (this.capabilityListeners.contains(listener)) {
            return;
        }
        this.capabilityListeners.add(listener);
    }

    @Override
    public void removeCapabilityListener(CapabilityListener listener) {
        this.capabilityListeners.remove(listener);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    protected void notifyCapabilityAdded(DiscoveryEntry addedCapability) {
        for (CapabilityListener capabilityListener : this.capabilityListeners) {
            capabilityListener.capabilityAdded(addedCapability);
        }
    }

    protected void notifyCapabilityRemoved(DiscoveryEntry removedCapability) {
        for (CapabilityListener capabilityListener : this.capabilityListeners) {
            capabilityListener.capabilityRemoved(removedCapability);
        }
    }
}

