/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.exceptions.JoynrCommunicationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryEntryStoreInMemory
implements DiscoveryEntryStore {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryEntryStoreInMemory.class);
    Map<String, Long> registeredCapabilitiesTime = new HashMap<String, Long>();
    Map<String, List<String>> interfaceAddressToCapabilityMapping = new HashMap<String, List<String>>();
    Map<String, String> participantIdToCapabilityMapping = new HashMap<String, String>();
    Map<String, DiscoveryEntry> capabilityKeyToCapabilityMapping = new HashMap<String, DiscoveryEntry>();
    Map<Address, List<String>> endPointAddressToCapabilityMapping = new HashMap<Address, List<String>>();
    private Object storeLock = new Object();

    @Inject
    public DiscoveryEntryStoreInMemory(CapabilitiesProvisioning staticProvisioning) {
        logger.trace("creating CapabilitiesStore {} with static provisioning", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(DiscoveryEntry discoveryEntry) {
        if (discoveryEntry.getDomain() == null || discoveryEntry.getInterfaceName() == null || discoveryEntry.getParticipantId() == null) {
            String message = "discoveryEntry being registered is not complete: " + discoveryEntry;
            logger.error(message);
            throw new JoynrCommunicationException(message);
        }
        Object object = this.storeLock;
        synchronized (object) {
            String discoveryEntryId = this.domainInterfaceParticipantIdKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName(), discoveryEntry.getParticipantId());
            DiscoveryEntry entry = this.capabilityKeyToCapabilityMapping.get(discoveryEntryId);
            if (entry != null) {
                this.remove(discoveryEntry.getParticipantId());
            }
            this.capabilityKeyToCapabilityMapping.put(discoveryEntryId, discoveryEntry);
            this.registeredCapabilitiesTime.put(discoveryEntryId, System.currentTimeMillis());
            String domainInterfaceId = this.domainInterfaceKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName());
            ArrayList<String> newMapping = new ArrayList<String>();
            ArrayList<String> mapping = this.interfaceAddressToCapabilityMapping.putIfAbsent(domainInterfaceId, newMapping);
            if (mapping == null) {
                mapping = newMapping;
            }
            mapping.add(discoveryEntryId);
            String participantId = discoveryEntry.getParticipantId();
            this.participantIdToCapabilityMapping.put(participantId, discoveryEntryId);
        }
    }

    public void add(Collection<? extends DiscoveryEntry> entries) {
        if (entries != null) {
            for (DiscoveryEntry discoveryEntry : entries) {
                this.add(discoveryEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String participantId) {
        boolean removedSuccessfully = false;
        Object object = this.storeLock;
        synchronized (object) {
            removedSuccessfully = this.removeDiscoveryEntryFromStore(participantId);
        }
        if (!removedSuccessfully) {
            logger.error("Could not find discoveryEntry to remove with Id: {}", (Object)participantId);
        }
        return removedSuccessfully;
    }

    private boolean removeDiscoveryEntryFromStore(String participantId) {
        String discoveryEntryId = this.participantIdToCapabilityMapping.get(participantId);
        if (discoveryEntryId == null) {
            return false;
        }
        DiscoveryEntry capability = this.capabilityKeyToCapabilityMapping.get(discoveryEntryId);
        if (capability == null) {
            return false;
        }
        String domainInterfaceId = this.domainInterfaceKey(capability.getDomain(), capability.getInterfaceName());
        DiscoveryEntry entry = this.capabilityKeyToCapabilityMapping.remove(discoveryEntryId);
        if (entry == null) {
            return false;
        }
        this.registeredCapabilitiesTime.remove(discoveryEntryId);
        List<String> mapping = this.interfaceAddressToCapabilityMapping.get(domainInterfaceId);
        if (mapping != null) {
            if (!mapping.remove(discoveryEntryId)) {
                logger.error("Could not find capability to remove from interfaceDomainToCapabilityMapping: {}", (Object)discoveryEntryId);
            }
            if (mapping.isEmpty()) {
                this.interfaceAddressToCapabilityMapping.remove(domainInterfaceId);
            }
        } else {
            logger.error("Could not find capability to remove from interfaceDomainToCapabilityMapping: {}", (Object)discoveryEntryId);
        }
        if (this.participantIdToCapabilityMapping.remove(participantId) == null) {
            logger.error("Could not find capability to remove from participantIdToCapabilityMapping: {}", (Object)discoveryEntryId);
        }
        return true;
    }

    public void remove(Collection<String> participantIds) {
        for (String participantId : participantIds) {
            this.remove(participantId);
        }
    }

    public Collection<DiscoveryEntry> lookup(String[] domains, String interfaceName) {
        return this.lookup(domains, interfaceName, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DiscoveryEntry> lookup(String[] domains, String interfaceName, long cacheMaxAge) {
        ArrayList<DiscoveryEntry> capabilitiesList = new ArrayList<DiscoveryEntry>();
        Object object = this.storeLock;
        synchronized (object) {
            for (String domain : domains) {
                String domainInterfacekey = this.domainInterfaceKey(domain, interfaceName);
                List<String> matchingDiscoveryEntries = this.interfaceAddressToCapabilityMapping.get(domainInterfacekey);
                if (matchingDiscoveryEntries == null) continue;
                for (String capId : matchingDiscoveryEntries) {
                    DiscoveryEntry discoveryEntry = this.capabilityKeyToCapabilityMapping.get(capId);
                    if (discoveryEntry instanceof GlobalDiscoveryEntry && !this.checkAge(this.registeredCapabilitiesTime.get(capId), cacheMaxAge)) continue;
                    capabilitiesList.add(discoveryEntry);
                }
            }
        }
        logger.debug("Capabilities found: {}", (Object)capabilitiesList.toString());
        return capabilitiesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public DiscoveryEntry lookup(String participantId, long cacheMaxAge) {
        Object object = this.storeLock;
        synchronized (object) {
            String discoveryEntryId = this.participantIdToCapabilityMapping.get(participantId);
            if (discoveryEntryId == null) {
                return null;
            }
            DiscoveryEntry discoveryEntry = this.capabilityKeyToCapabilityMapping.get(discoveryEntryId);
            logger.debug("Capability for participantId {} found: {}", (Object)participantId, (Object)discoveryEntry);
            if (discoveryEntry instanceof GlobalDiscoveryEntry && !this.checkAge(this.registeredCapabilitiesTime.get(discoveryEntryId), cacheMaxAge)) {
                return null;
            }
            return discoveryEntry;
        }
    }

    public HashSet<DiscoveryEntry> getAllDiscoveryEntries() {
        HashSet<DiscoveryEntry> allDiscoveryEntries = new HashSet<DiscoveryEntry>();
        return allDiscoveryEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDiscoveryEntry(@Nonnull DiscoveryEntry discoveryEntry) {
        Object object = this.storeLock;
        synchronized (object) {
            String discoveryEntryId = this.domainInterfaceParticipantIdKey(discoveryEntry.getDomain(), discoveryEntry.getInterfaceName(), discoveryEntry.getParticipantId());
            return this.registeredCapabilitiesTime.containsKey(discoveryEntryId);
        }
    }

    String domainInterfaceParticipantIdKey(String domain, String interfaceName, String participantId) {
        return (this.domainInterfaceKey(domain, interfaceName) + "|" + participantId).toLowerCase();
    }

    String domainInterfaceKey(String domain, String interfaceName) {
        return (domain + "|" + interfaceName).toLowerCase();
    }

    private boolean checkAge(Long timeStamp, long maxAcceptedAge) {
        return timeStamp != null && System.currentTimeMillis() - timeStamp <= maxAcceptedAge;
    }

    public void touch(String clusterControllerId) {
    }
}

