/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.capabilities.AbstractLocalCapabilitiesDirectory;
import io.joynr.capabilities.CapabilitiesCallback;
import io.joynr.capabilities.CapabilityCallback;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import joynr.exceptions.ProviderRuntimeException;
import joynr.system.DiscoveryProvider;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.DiscoveryQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyCapabilitiesDirectory
extends AbstractLocalCapabilitiesDirectory {
    private static final Logger logger = LoggerFactory.getLogger(DummyCapabilitiesDirectory.class);
    private static final DummyCapabilitiesDirectory instance = new DummyCapabilitiesDirectory();
    private ArrayList<DiscoveryEntryWithMetaInfo> registeredCapabilities = Lists.newArrayList();
    @Inject
    @Named(value="joynr.messaging.channelId")
    String myChannelId;

    public static DummyCapabilitiesDirectory getInstance() {
        return instance;
    }

    @Override
    public Promise<DeferredVoid> add(DiscoveryEntry discoveryEntry) {
        DeferredVoid deferred = new DeferredVoid();
        this.registeredCapabilities.add(CapabilityUtils.convertToDiscoveryEntryWithMetaInfo((boolean)true, (DiscoveryEntry)discoveryEntry));
        this.notifyCapabilityAdded(discoveryEntry);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> add(DiscoveryEntry discoveryEntry, Boolean awaitGlobalRegistration) {
        return this.add(discoveryEntry);
    }

    public Promise<DiscoveryProvider.Lookup1Deferred> lookup(String[] domains, String interfaceName, DiscoveryQos discoveryQos) {
        final DiscoveryProvider.Lookup1Deferred deferred = new DiscoveryProvider.Lookup1Deferred();
        CapabilitiesCallback callback = new CapabilitiesCallback(){

            @Override
            public void processCapabilitiesReceived(@CheckForNull Collection<DiscoveryEntryWithMetaInfo> capabilities) {
                if (capabilities != null) {
                    deferred.resolve(capabilities.toArray(new DiscoveryEntryWithMetaInfo[0]));
                } else {
                    deferred.reject(new ProviderRuntimeException("Received capabilities list was null"));
                }
            }

            @Override
            public void onError(Throwable e) {
                deferred.reject(new ProviderRuntimeException(e.toString()));
            }
        };
        DiscoveryScope discoveryScope = DiscoveryScope.valueOf((String)discoveryQos.getDiscoveryScope().name());
        this.lookup(domains, interfaceName, new io.joynr.arbitration.DiscoveryQos(30000L, ArbitrationStrategy.NotSet, discoveryQos.getCacheMaxAge().longValue(), discoveryScope), callback);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DiscoveryProvider.Lookup2Deferred> lookup(String participantId) {
        DiscoveryProvider.Lookup2Deferred deferred = new DiscoveryProvider.Lookup2Deferred();
        DiscoveryEntryWithMetaInfo discoveryEntry = this.lookup(participantId, io.joynr.arbitration.DiscoveryQos.NO_FILTER);
        deferred.resolve(discoveryEntry);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(String participantId) {
        DeferredVoid deferred = new DeferredVoid();
        logger.info("!!!!!!!!!!!!!!!removeCapabilities");
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    @Override
    public void remove(DiscoveryEntry interfaces) {
        logger.info("!!!!!!!!!!!!!!!removeCapabilities");
    }

    @Override
    public void lookup(String[] domains, String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback) {
        logger.info("!!!!!!!!!!!!!!!getCapabilities async");
        ArrayList foundCapabilities = Lists.newArrayList();
        for (String domain : domains) {
            for (DiscoveryEntryWithMetaInfo ce : this.registeredCapabilities) {
                if (!ce.getDomain().equals(domain) || !ce.getInterfaceName().equals(interfaceName)) continue;
                foundCapabilities.add(ce);
            }
        }
        capabilitiesCallback.processCapabilitiesReceived(foundCapabilities);
    }

    @Override
    @CheckForNull
    public void lookup(String participantId, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilityCallback callback) {
        logger.info("!!!!!!!!!!!!!!!getCapabilitiesForParticipantId");
    }

    @Override
    @CheckForNull
    public DiscoveryEntryWithMetaInfo lookup(String participantId, io.joynr.arbitration.DiscoveryQos discoveryQos) {
        logger.info("!!!!!!!!!!!!!!!getCapabilitiesForParticipantId");
        DiscoveryEntryWithMetaInfo retrievedDiscoveryEntry = null;
        for (DiscoveryEntryWithMetaInfo entry : this.registeredCapabilities) {
            if (!entry.getParticipantId().equals(participantId)) continue;
            retrievedDiscoveryEntry = entry;
            break;
        }
        return retrievedDiscoveryEntry;
    }

    @Override
    public void shutdown(boolean unregisterAllRegisteredCapabilities) {
        this.registeredCapabilities.clear();
    }

    @Override
    public Set<DiscoveryEntry> listLocalCapabilities() {
        return new HashSet<DiscoveryEntryWithMetaInfo>(this.registeredCapabilities);
    }
}

