/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class QualityOfServiceParameter {
    Object parameter;
    Class<?> type;

    @JsonCreator
    public QualityOfServiceParameter(@JsonProperty(value="parameter") Object parameter) {
        this.parameter = parameter;
        this.type = parameter.getClass();
    }

    @JsonProperty(value="parameter")
    public Object getParameter() {
        return this.parameter;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public boolean matches(QualityOfServiceParameter requestedParameter) {
        if (requestedParameter.type != this.type) {
            return false;
        }
        if (this.type == String.class) {
            return this.matchString(requestedParameter);
        }
        if (this.type == Integer.TYPE) {
            return this.matchLong(requestedParameter);
        }
        if (this.type == Boolean.TYPE) {
            return this.matchBoolean(requestedParameter);
        }
        return false;
    }

    private boolean matchBoolean(QualityOfServiceParameter requestedParameter) {
        return this.parameter.equals(requestedParameter.getParameter());
    }

    private boolean matchLong(QualityOfServiceParameter requestedParameter) {
        return (Long)this.parameter >= (Long)requestedParameter.getParameter();
    }

    private boolean matchString(QualityOfServiceParameter requestedParameter) {
        return ((String)requestedParameter.getParameter()).compareTo((String)this.parameter) == 0;
    }
}

