/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.database;

import io.joynr.database.QueryProcessor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoynrEmbeddedDatabase {
    private static final Logger logger = LoggerFactory.getLogger(JoynrEmbeddedDatabase.class);
    public static final String PROPERTY_DATABASE_NAME = "joynr.database.embedded.database";
    private boolean started = false;
    private Connection connection = null;
    private String dbName;

    public JoynrEmbeddedDatabase(String dbName) {
        this.dbName = dbName;
    }

    public String getDBName() {
        return this.dbName;
    }

    protected abstract String getDBCreateUrl();

    protected abstract String getDBCloseUrl();

    public synchronized void start() throws SQLException {
        this.connection = DriverManager.getConnection(this.getDBCreateUrl());
        this.started = true;
    }

    public synchronized boolean isTableAlreadyContainedInDatabase(String tableName) {
        if (!this.started) {
            throw new IllegalStateException("Database is not started");
        }
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            ResultSet result = metaData.getTables(null, null, null, new String[]{"TABLE"});
            while (result.next()) {
                if (!result.getString("TABLE_NAME").equalsIgnoreCase(tableName)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            logger.debug("error checking if table exists", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String sqlStatement) throws SQLException {
        if (!this.started) {
            throw new IllegalStateException("No database access shall be made while it is not started!");
        }
        boolean result = false;
        try (Statement statement = this.connection.createStatement();){
            result = statement.execute(sqlStatement);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T executeQuery(String sqlStatement, QueryProcessor<T> processor) throws SQLException {
        if (!this.started) {
            throw new IllegalStateException("No query shall be made to the database while it is not started!");
        }
        try (Statement statement = this.connection.createStatement();){
            T result;
            ResultSet resultSet = statement.executeQuery(sqlStatement);
            T t = result = processor.processQueryResult(resultSet);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T executeQuery(PreparedStatement preparedStatement, QueryProcessor<T> processor) throws SQLException {
        if (!this.started) {
            throw new IllegalStateException("No query shall be made to the database while it is not started!");
        }
        T result = null;
        try (ResultSet resultSet = null;){
            resultSet = preparedStatement.executeQuery();
            result = processor.processQueryResult(resultSet);
        }
        return result;
    }

    public synchronized void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.started = false;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.started) {
            throw new IllegalStateException("No query shall be made to the database while it is not started!");
        }
        return this.connection.prepareStatement(sql);
    }
}

