/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.database.derby;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.database.JoynrEmbeddedDatabase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrDerbyDatabase
extends JoynrEmbeddedDatabase {
    private static final String dbUrl_prefix = "jdbc:derby";
    private static final String dbUrl_createpostfix = ";create=true";
    private static final String dbUrl_closepostfix = ";shutdown=true";
    private static Logger log = LoggerFactory.getLogger(JoynrDerbyDatabase.class);

    @Inject
    public JoynrDerbyDatabase(@Named(value="joynr.database.embedded.database") String dbName) throws ClassNotFoundException {
        super(dbName);
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        }
        catch (ClassNotFoundException e) {
            log.error("Class \"org.apache.derby.jdbc.EmbeddedDriver\" could not be found in the classpath. Please fix the classpath!", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected String getDBCreateUrl() {
        return "jdbc:derby:" + this.getDBName() + dbUrl_createpostfix;
    }

    @Override
    protected String getDBCloseUrl() {
        return "jdbc:derby:" + this.getDBName() + dbUrl_closepostfix;
    }

    @Override
    public synchronized void close() throws SQLException {
        try (Connection connection = null;){
            connection = DriverManager.getConnection(this.getDBCloseUrl());
        }
        super.close();
    }
}

