/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.statusmetrics;

import io.joynr.statusmetrics.ConnectionStatusMetrics;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionStatusMetricsImpl
implements ConnectionStatusMetrics {
    private Optional<String> gbid = Optional.empty();
    private String url;
    private boolean isSender;
    private boolean isReceiver;
    private boolean isReplyReceiver;
    private AtomicBoolean isConnected = new AtomicBoolean();
    private volatile Instant lastStateChange = Instant.now();
    private AtomicLong receivedMessages = new AtomicLong();
    private AtomicLong sentMessages = new AtomicLong();
    private AtomicLong connectionDrops = new AtomicLong();
    private AtomicLong connectionAttempts = new AtomicLong();

    public void setGbid(String gbid) {
        this.gbid = Optional.of(gbid);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSender(boolean isSender) {
        this.isSender = isSender;
    }

    public void setReceiver(boolean isReceiver) {
        this.isReceiver = isReceiver;
    }

    public void setReplyReceiver(boolean isReplyReceiver) {
        this.isReplyReceiver = isReplyReceiver;
    }

    public void setConnected(boolean isConnected) {
        if (this.isConnected.compareAndSet(!isConnected, isConnected)) {
            this.lastStateChange = Instant.now();
        }
    }

    public void increaseReceivedMessages() {
        this.receivedMessages.incrementAndGet();
    }

    public void increaseSentMessages() {
        this.sentMessages.incrementAndGet();
    }

    public void increaseConnectionDrops() {
        this.connectionDrops.incrementAndGet();
    }

    public void increaseConnectionAttempts() {
        this.connectionAttempts.incrementAndGet();
    }

    @Override
    public Optional<String> getGbid() {
        return this.gbid;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isSender() {
        return this.isSender;
    }

    @Override
    public boolean isReceiver() {
        return this.isReceiver;
    }

    @Override
    public boolean isReplyReceiver() {
        return this.isReplyReceiver;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.get();
    }

    @Override
    public Instant getLastConnectionStateChangeDate() {
        return this.lastStateChange;
    }

    @Override
    public long getReceivedMessages() {
        return this.receivedMessages.get();
    }

    @Override
    public long getSentMessages() {
        return this.sentMessages.get();
    }

    @Override
    public long getConnectionDrops() {
        return this.connectionDrops.get();
    }

    @Override
    public long getConnectionAttempts() {
        return this.connectionAttempts.get();
    }
}

