/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.statusmetrics;

import com.google.inject.Singleton;
import io.joynr.statusmetrics.ConnectionStatusMetrics;
import io.joynr.statusmetrics.JoynrStatusMetricsReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

@Singleton
public class JoynrStatusMetricsAggregator
implements JoynrStatusMetricsReceiver {
    private List<ConnectionStatusMetrics> connectionStatusMetricsList = new CopyOnWriteArrayList<ConnectionStatusMetrics>();
    private AtomicLong droppedMessages = new AtomicLong();

    @Override
    public Collection<ConnectionStatusMetrics> getAllConnectionStatusMetrics() {
        ArrayList<ConnectionStatusMetrics> returnList = new ArrayList<ConnectionStatusMetrics>(this.connectionStatusMetricsList);
        return returnList;
    }

    @Override
    public Collection<ConnectionStatusMetrics> getConnectionStatusMetrics(String gbid) {
        ArrayList<ConnectionStatusMetrics> returnList = new ArrayList<ConnectionStatusMetrics>();
        for (ConnectionStatusMetrics metrics : this.connectionStatusMetricsList) {
            Optional<String> metricsGbid = metrics.getGbid();
            if (!metricsGbid.isPresent() || !metricsGbid.get().equals(gbid)) continue;
            returnList.add(metrics);
        }
        return returnList;
    }

    @Override
    public void addConnectionStatusMetrics(ConnectionStatusMetrics metrics) {
        this.connectionStatusMetricsList.add(metrics);
    }

    @Override
    public void notifyMessageDropped() {
        this.droppedMessages.incrementAndGet();
    }

    @Override
    public long getNumDroppedMessages() {
        return this.droppedMessages.get();
    }
}

