/*
 * Decompiled with CFR 0.152.
 */
package joynr.types;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.types.CommunicationMiddleware;
import joynr.types.ProviderQos;

public class DiscoveryEntry
implements Serializable,
JoynrType {
    private String domain;
    private String interfaceName;
    private String participantId;
    private ProviderQos qos;
    private List<CommunicationMiddleware> connections = Lists.newArrayList();

    public DiscoveryEntry() {
        this.domain = "";
        this.interfaceName = "";
        this.participantId = "";
        this.qos = new ProviderQos();
        this.connections = new ArrayList<CommunicationMiddleware>();
    }

    public DiscoveryEntry(DiscoveryEntry discoveryEntryObj) {
        this.domain = discoveryEntryObj.domain;
        this.interfaceName = discoveryEntryObj.interfaceName;
        this.participantId = discoveryEntryObj.participantId;
        this.qos = new ProviderQos(discoveryEntryObj.qos);
        this.connections = new ArrayList<CommunicationMiddleware>(discoveryEntryObj.connections);
    }

    public DiscoveryEntry(String domain, String interfaceName, String participantId, ProviderQos qos, List<CommunicationMiddleware> connections) {
        this.domain = domain;
        this.interfaceName = interfaceName;
        this.participantId = participantId;
        this.qos = qos;
        this.connections = connections;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public ProviderQos getQos() {
        return this.qos;
    }

    public void setQos(ProviderQos qos) {
        this.qos = qos;
    }

    public List<CommunicationMiddleware> getConnections() {
        return this.connections;
    }

    public void setConnections(List<CommunicationMiddleware> connections) {
        this.connections = connections;
    }

    public String toString() {
        return "DiscoveryEntry [domain=" + this.domain + ", " + "interfaceName=" + this.interfaceName + ", " + "participantId=" + this.participantId + ", " + "qos=" + this.qos + ", " + "connections=" + this.connections + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryEntry other = (DiscoveryEntry)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId)) {
            return false;
        }
        if (this.qos == null ? other.qos != null : !this.qos.equals(other.qos)) {
            return false;
        }
        return !(this.connections == null ? other.connections != null : !this.connections.equals(other.connections));
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.qos == null ? 0 : this.qos.hashCode());
        result = 31 * result + (this.connections == null ? 0 : this.connections.hashCode());
        return result;
    }
}

