/*
 * Decompiled with CFR 0.152.
 */
package joynr.infrastructure.DacTypes;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.infrastructure.DacTypes.MasterControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;

public class MasterAccessControlEntry
extends MasterControlEntry
implements Serializable,
JoynrType {
    private String operation;
    private Permission defaultConsumerPermission;
    private List<Permission> possibleConsumerPermissions = Lists.newArrayList();

    public MasterAccessControlEntry() {
        this.operation = "";
        this.defaultConsumerPermission = Permission.YES;
        this.possibleConsumerPermissions = new ArrayList<Permission>();
    }

    public MasterAccessControlEntry(MasterAccessControlEntry masterAccessControlEntryObj) {
        super(masterAccessControlEntryObj);
        this.operation = masterAccessControlEntryObj.operation;
        this.defaultConsumerPermission = masterAccessControlEntryObj.defaultConsumerPermission;
        this.possibleConsumerPermissions = new ArrayList<Permission>(masterAccessControlEntryObj.possibleConsumerPermissions);
    }

    public MasterAccessControlEntry(String uid, String domain, String interfaceName, TrustLevel defaultRequiredTrustLevel, List<TrustLevel> possibleRequiredTrustLevels, TrustLevel defaultRequiredControlEntryChangeTrustLevel, List<TrustLevel> possibleRequiredControlEntryChangeTrustLevels, String operation, Permission defaultConsumerPermission, List<Permission> possibleConsumerPermissions) {
        super(uid, domain, interfaceName, defaultRequiredTrustLevel, possibleRequiredTrustLevels, defaultRequiredControlEntryChangeTrustLevel, possibleRequiredControlEntryChangeTrustLevels);
        this.operation = operation;
        this.defaultConsumerPermission = defaultConsumerPermission;
        this.possibleConsumerPermissions = possibleConsumerPermissions;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Permission getDefaultConsumerPermission() {
        return this.defaultConsumerPermission;
    }

    public void setDefaultConsumerPermission(Permission defaultConsumerPermission) {
        this.defaultConsumerPermission = defaultConsumerPermission;
    }

    public List<Permission> getPossibleConsumerPermissions() {
        return this.possibleConsumerPermissions;
    }

    public void setPossibleConsumerPermissions(List<Permission> possibleConsumerPermissions) {
        this.possibleConsumerPermissions = possibleConsumerPermissions;
    }

    @Override
    public String toString() {
        return "MasterAccessControlEntry [" + super.toString() + ", " + "operation=" + this.operation + ", " + "defaultConsumerPermission=" + (Object)((Object)this.defaultConsumerPermission) + ", " + "possibleConsumerPermissions=" + this.possibleConsumerPermissions + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MasterAccessControlEntry other = (MasterAccessControlEntry)obj;
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.defaultConsumerPermission == null ? other.defaultConsumerPermission != null : !this.defaultConsumerPermission.equals((Object)other.defaultConsumerPermission)) {
            return false;
        }
        return !(this.possibleConsumerPermissions == null ? other.possibleConsumerPermissions != null : !this.possibleConsumerPermissions.equals(other.possibleConsumerPermissions));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.defaultConsumerPermission == null ? 0 : this.defaultConsumerPermission.hashCode());
        result = 31 * result + (this.possibleConsumerPermissions == null ? 0 : this.possibleConsumerPermissions.hashCode());
        return result;
    }
}

