/*
 * Decompiled with CFR 0.152.
 */
package joynr.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.Arrays;
import joynr.types.CommunicationMiddleware;
import joynr.types.ProviderQos;

public class DiscoveryEntry
implements Serializable,
JoynrType {
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="interfaceName")
    private String interfaceName;
    @JsonProperty(value="participantId")
    private String participantId;
    @JsonProperty(value="qos")
    private ProviderQos qos;
    @JsonProperty(value="connections")
    private CommunicationMiddleware[] connections = new CommunicationMiddleware[0];

    public DiscoveryEntry() {
        this.domain = "";
        this.interfaceName = "";
        this.participantId = "";
        this.qos = new ProviderQos();
    }

    public DiscoveryEntry(DiscoveryEntry discoveryEntryObj) {
        this.domain = discoveryEntryObj.domain;
        this.interfaceName = discoveryEntryObj.interfaceName;
        this.participantId = discoveryEntryObj.participantId;
        this.qos = new ProviderQos(discoveryEntryObj.qos);
        this.connections = discoveryEntryObj.connections;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="joynr object not used for storing internal state")
    public DiscoveryEntry(String domain, String interfaceName, String participantId, ProviderQos qos, CommunicationMiddleware[] connections) {
        this.domain = domain;
        this.interfaceName = interfaceName;
        this.participantId = participantId;
        this.qos = qos;
        this.connections = connections;
    }

    @JsonIgnore
    public String getDomain() {
        return this.domain;
    }

    @JsonIgnore
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonIgnore
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @JsonIgnore
    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @JsonIgnore
    public String getParticipantId() {
        return this.participantId;
    }

    @JsonIgnore
    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    @JsonIgnore
    public ProviderQos getQos() {
        return this.qos;
    }

    @JsonIgnore
    public void setQos(ProviderQos qos) {
        this.qos = qos;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="joynr object not used for storing internal state")
    public CommunicationMiddleware[] getConnections() {
        return this.connections;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="joynr object not used for storing internal state")
    public void setConnections(CommunicationMiddleware[] connections) {
        this.connections = connections;
    }

    public String toString() {
        return "DiscoveryEntry [domain=" + this.domain + ", " + "interfaceName=" + this.interfaceName + ", " + "participantId=" + this.participantId + ", " + "qos=" + this.qos + ", " + "connections=" + Arrays.toString((Object[])this.connections) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryEntry other = (DiscoveryEntry)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId)) {
            return false;
        }
        if (this.qos == null ? other.qos != null : !this.qos.equals(other.qos)) {
            return false;
        }
        return !(this.connections == null ? other.connections != null : !Arrays.deepEquals((Object[])this.connections, (Object[])other.connections));
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.qos == null ? 0 : this.qos.hashCode());
        result = 31 * result + (this.connections == null ? 0 : Arrays.hashCode((Object[])this.connections));
        return result;
    }
}

