/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import io.joynr.pubsub.SubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicSubscriptionQos
extends SubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final Logger logger = LoggerFactory.getLogger(PeriodicSubscriptionQos.class);
    private static final long MIN_PERIOD = 50L;
    private static final long MAX_PERIOD = 2592000000L;
    private static final long MIN_ALERT_AFTER_INTERVAL = 50L;
    private static final long MAX_ALERT_AFTER_INTERVAL = 2592000000L;
    private static final long DEFAULT_ALERT_AFTER_INTERVAL = 0L;
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private long period = 50L;
    private long alertAfterInterval = 0L;

    protected PeriodicSubscriptionQos() {
    }

    public PeriodicSubscriptionQos(long period, long expiryDate, long alertAfterInterval, long publicationTtl) {
        super(expiryDate, publicationTtl);
        this.setPeriod(period);
        this.setAlertAfterInterval(alertAfterInterval);
    }

    public PeriodicSubscriptionQos(long period, long expiryDate, long publicationTtl) {
        this(period, expiryDate, 0L, publicationTtl);
    }

    public long getAlertAfterInterval() {
        return this.alertAfterInterval;
    }

    public void setAlertAfterInterval(long alertAfterInterval_ms) {
        if (alertAfterInterval_ms < this.period && alertAfterInterval_ms != 0L) {
            this.alertAfterInterval = 50L;
            logger.warn("alertAfterInterval_ms < MIN_ALERT_AFTER_INTERVAL. Using MIN_ALERT_AFTER_INTERVAL: {}", (Object)50L);
            return;
        }
        if (alertAfterInterval_ms > 2592000000L) {
            this.alertAfterInterval = 2592000000L;
            logger.warn("alertAfterInterval_ms > MAX_ALERT_AFTER_INTERVAL. Using MAX_ALERT_AFTER_INTERVAL: {}", (Object)2592000000L);
            return;
        }
        this.alertAfterInterval = alertAfterInterval_ms;
    }

    public void clearAlertAfterInterval() {
        this.alertAfterInterval = 0L;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period_ms) {
        if (period_ms < 50L) {
            this.period = 50L;
            logger.warn("alertAfterInterval_ms < MIN_PERIOD. Using MIN_PERIOD: {}", (Object)50L);
            return;
        }
        if (period_ms > 2592000000L) {
            this.period = 2592000000L;
            logger.warn("alertAfterInterval_ms > MAX_PERIOD. Using MAX_PERIOD: {}", (Object)2592000000L);
            return;
        }
        this.period = period_ms;
        if (this.alertAfterInterval != 0L && this.alertAfterInterval < this.period) {
            this.alertAfterInterval = this.period;
        }
    }

    @JsonIgnore
    public long getHeartbeat() {
        return this.period;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.alertAfterInterval ^ this.alertAfterInterval >>> 32);
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PeriodicSubscriptionQos other = (PeriodicSubscriptionQos)((Object)obj);
        if (this.alertAfterInterval != other.alertAfterInterval) {
            return false;
        }
        return this.period == other.period;
    }
}

