/*
 * Decompiled with CFR 0.152.
 */
package joynr.system.RoutingTypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.WebSocketProtocol;

public class WebSocketAddress
extends Address
implements Serializable,
JoynrType {
    @JsonProperty(value="protocol")
    private WebSocketProtocol protocol;
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="path")
    private String path;

    public WebSocketAddress() {
        this.protocol = WebSocketProtocol.WS;
        this.host = "";
        this.port = 0;
        this.path = "";
    }

    public WebSocketAddress(WebSocketAddress webSocketAddressObj) {
        super(webSocketAddressObj);
        this.protocol = webSocketAddressObj.protocol;
        this.host = webSocketAddressObj.host;
        this.port = webSocketAddressObj.port;
        this.path = webSocketAddressObj.path;
    }

    public WebSocketAddress(WebSocketProtocol protocol, String host, Integer port, String path) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    @JsonIgnore
    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    @JsonIgnore
    public void setProtocol(WebSocketProtocol protocol) {
        this.protocol = protocol;
    }

    @JsonIgnore
    public String getHost() {
        return this.host;
    }

    @JsonIgnore
    public void setHost(String host) {
        this.host = host;
    }

    @JsonIgnore
    public Integer getPort() {
        return this.port;
    }

    @JsonIgnore
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        return "WebSocketAddress [" + super.toString() + ", " + "protocol=" + (Object)((Object)this.protocol) + ", " + "host=" + this.host + ", " + "port=" + this.port + ", " + "path=" + this.path + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        WebSocketAddress other = (WebSocketAddress)obj;
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }
}

