/*
 * Decompiled with CFR 0.152.
 */
package joynr.system.RoutingTypes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.io.IOException;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;

public class RoutingTypesUtil {
    static ObjectMapper objectMapper = new ObjectMapper();

    public static String toAddressString(Address address) {
        if (address instanceof ChannelAddress) {
            return ((ChannelAddress)address).getChannelId();
        }
        if (address instanceof MqttAddress) {
            MqttAddress mqttAddress = (MqttAddress)address;
            try {
                return objectMapper.writeValueAsString((Object)mqttAddress);
            }
            catch (JsonProcessingException e) {
                throw new JoynrIllegalStateException("MQTT address could not be serilaized: " + e.getMessage());
            }
        }
        throw new JoynrIllegalStateException("unable to convert address to string: unknown address type: " + address);
    }

    public static Address fromAddressString(String addressString) {
        if (addressString.startsWith("{")) {
            try {
                return (Address)objectMapper.readValue(addressString, MqttAddress.class);
            }
            catch (IOException e) {
                throw new JoynrIllegalStateException("unable to deserialize address: " + addressString + " reason:" + e.getMessage());
            }
        }
        return new ChannelAddress(addressString);
    }
}

