/*
 * Decompiled with CFR 0.152.
 */
package joynr.system;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.Arrays;
import joynr.system.JoynrLogLevel;
import joynr.system.JoynrLoggedError;
import joynr.system.JoynrLoggingContextTag;

public class JoynrLogEvent
implements Serializable,
JoynrType {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 0;
    @JsonProperty(value="timestamp")
    private Long timestamp;
    @JsonProperty(value="eventVersion")
    private String eventVersion;
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="priority")
    private JoynrLogLevel priority;
    @JsonProperty(value="errorEvent")
    private JoynrLoggedError errorEvent;
    @JsonProperty(value="tags")
    private JoynrLoggingContextTag[] tags = new JoynrLoggingContextTag[0];

    public JoynrLogEvent() {
        this.timestamp = 0L;
        this.eventVersion = "";
        this.host = "";
        this.path = "";
        this.message = "";
        this.priority = JoynrLogLevel.OFF;
        this.errorEvent = new JoynrLoggedError();
    }

    public JoynrLogEvent(JoynrLogEvent joynrLogEventObj) {
        this.timestamp = joynrLogEventObj.timestamp;
        this.eventVersion = joynrLogEventObj.eventVersion;
        this.host = joynrLogEventObj.host;
        this.path = joynrLogEventObj.path;
        this.message = joynrLogEventObj.message;
        this.priority = joynrLogEventObj.priority;
        this.errorEvent = new JoynrLoggedError(joynrLogEventObj.errorEvent);
        this.tags = joynrLogEventObj.tags;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="joynr object not used for storing internal state")
    public JoynrLogEvent(Long timestamp, String eventVersion, String host, String path, String message, JoynrLogLevel priority, JoynrLoggedError errorEvent, JoynrLoggingContextTag[] tags) {
        this.timestamp = timestamp;
        this.eventVersion = eventVersion;
        this.host = host;
        this.path = path;
        this.message = message;
        this.priority = priority;
        this.errorEvent = errorEvent;
        this.tags = tags;
    }

    @JsonIgnore
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonIgnore
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public String getEventVersion() {
        return this.eventVersion;
    }

    @JsonIgnore
    public void setEventVersion(String eventVersion) {
        this.eventVersion = eventVersion;
    }

    @JsonIgnore
    public String getHost() {
        return this.host;
    }

    @JsonIgnore
    public void setHost(String host) {
        this.host = host;
    }

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public void setPath(String path) {
        this.path = path;
    }

    @JsonIgnore
    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public JoynrLogLevel getPriority() {
        return this.priority;
    }

    @JsonIgnore
    public void setPriority(JoynrLogLevel priority) {
        this.priority = priority;
    }

    @JsonIgnore
    public JoynrLoggedError getErrorEvent() {
        return this.errorEvent;
    }

    @JsonIgnore
    public void setErrorEvent(JoynrLoggedError errorEvent) {
        this.errorEvent = errorEvent;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="joynr object not used for storing internal state")
    public JoynrLoggingContextTag[] getTags() {
        return this.tags;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="joynr object not used for storing internal state")
    public void setTags(JoynrLoggingContextTag[] tags) {
        this.tags = tags;
    }

    public String toString() {
        return "JoynrLogEvent [timestamp=" + this.timestamp + ", " + "eventVersion=" + this.eventVersion + ", " + "host=" + this.host + ", " + "path=" + this.path + ", " + "message=" + this.message + ", " + "priority=" + (Object)((Object)this.priority) + ", " + "errorEvent=" + this.errorEvent + ", " + "tags=" + Arrays.toString(this.tags) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrLogEvent other = (JoynrLogEvent)obj;
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.eventVersion == null ? other.eventVersion != null : !this.eventVersion.equals(other.eventVersion)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals((Object)other.priority)) {
            return false;
        }
        if (this.errorEvent == null ? other.errorEvent != null : !this.errorEvent.equals(other.errorEvent)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !Arrays.deepEquals(this.tags, other.tags));
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.eventVersion == null ? 0 : this.eventVersion.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.errorEvent == null ? 0 : this.errorEvent.hashCode());
        result = 31 * result + (this.tags == null ? 0 : Arrays.hashCode(this.tags));
        return result;
    }
}

