/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import joynr.OnChangeSubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnChangeWithKeepAliveSubscriptionQos
extends OnChangeSubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(OnChangeWithKeepAliveSubscriptionQos.class);
    private static final long MIN_MAX_INTERVAL_MS = 50L;
    private static final long MAX_MAX_INTERVAL_MS = 2592000000L;
    private static final long DEFAULT_MAX_INTERVAL_MS = 60000L;
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private static final long DEFAULT_ALERT_AFTER_INTERVAL_MS = 0L;
    private static final long MAX_ALERT_AFTER_INTERVAL_MS = 2592000000L;
    private long maxIntervalMs = 60000L;
    private long alertAfterIntervalMs = 0L;

    public OnChangeWithKeepAliveSubscriptionQos() {
    }

    @Deprecated
    public OnChangeWithKeepAliveSubscriptionQos(long minIntervalMs, long maxIntervalMs, long expiryDateMs) {
        this(minIntervalMs, maxIntervalMs, expiryDateMs, 0L, 10000L);
    }

    @Deprecated
    public OnChangeWithKeepAliveSubscriptionQos(long minIntervalMs, long maxIntervalMs, long expiryDateMs, long alertAfterIntervalMs) {
        this(minIntervalMs, maxIntervalMs, expiryDateMs, alertAfterIntervalMs, 10000L);
    }

    @Deprecated
    public OnChangeWithKeepAliveSubscriptionQos(long minIntervalMs, long maxIntervalMs, long expiryDateMs, long alertAfterIntervalMs, long publicationTtlMs) {
        super(minIntervalMs, expiryDateMs, publicationTtlMs);
        this.setMaxIntervalMs(maxIntervalMs);
        this.setAlertAfterIntervalMs(alertAfterIntervalMs);
    }

    @Deprecated
    public long getMaxInterval() {
        return this.getMaxIntervalMs();
    }

    public long getMaxIntervalMs() {
        return this.maxIntervalMs;
    }

    public long getPeriodMs() {
        return this.getMaxIntervalMs();
    }

    @Deprecated
    public OnChangeWithKeepAliveSubscriptionQos setMaxInterval(long maxIntervalMs) {
        return this.setMaxIntervalMs(maxIntervalMs);
    }

    public OnChangeWithKeepAliveSubscriptionQos setMaxIntervalMs(long maxIntervalMs) {
        if (maxIntervalMs < 50L) {
            this.maxIntervalMs = 50L;
            logger.warn("maxIntervalMs < MIN_MAX_INTERVAL_MS. Using MIN_MAX_INTERVAL_MS: {}", (Object)50L);
        } else if (maxIntervalMs > 2592000000L) {
            this.maxIntervalMs = 2592000000L;
            logger.warn("maxIntervalMs > MAX_MAX_INTERVAL_MS. Using MAX_MAX_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.maxIntervalMs = maxIntervalMs;
        }
        if (this.maxIntervalMs < this.getMinIntervalMs()) {
            this.maxIntervalMs = this.getMinIntervalMs();
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.maxIntervalMs) {
            this.alertAfterIntervalMs = this.maxIntervalMs;
            logger.warn("alertAfterIntervalMs < maxIntervalMs. Setting alertAfterIntervalMs = maxIntervalMs: {}", (Object)this.maxIntervalMs);
        }
        return this;
    }

    @Deprecated
    public long getAlertAfterInterval() {
        return this.alertAfterIntervalMs;
    }

    public long getAlertAfterIntervalMs() {
        return this.alertAfterIntervalMs;
    }

    @Deprecated
    public OnChangeWithKeepAliveSubscriptionQos setAlertAfterInterval(long alertAfterIntervalMs) {
        return this.setAlertAfterIntervalMs(alertAfterIntervalMs);
    }

    public OnChangeWithKeepAliveSubscriptionQos setAlertAfterIntervalMs(long alertAfterIntervalMs) {
        if (alertAfterIntervalMs > 2592000000L) {
            this.alertAfterIntervalMs = 2592000000L;
            logger.warn("alertAfterIntervalMs > maxInterval. Using MAX_ALERT_AFTER_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.alertAfterIntervalMs = alertAfterIntervalMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.maxIntervalMs) {
            this.alertAfterIntervalMs = this.maxIntervalMs;
            logger.warn("attempt to set alertAfterIntervalMs to a value smaller than maxInterval; setting to maxInterval instead");
        }
        return this;
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setExpiryDateMs(long expiryDateMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setExpiryDateMs(expiryDateMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setMinIntervalMs(long minIntervalMs) {
        super.setMinIntervalMs(minIntervalMs);
        return this.setMaxIntervalMs(this.maxIntervalMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setPublicationTtlMs(publicationTtlMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setValidityMs(long validityMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setValidityMs(validityMs);
    }

    public void clearAlertAfterInterval() {
        this.alertAfterIntervalMs = 0L;
    }

    @JsonIgnore
    @Deprecated
    public long getHeartbeat() {
        return this.maxIntervalMs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.alertAfterIntervalMs ^ this.alertAfterIntervalMs >>> 32);
        result = 31 * result + (int)(this.maxIntervalMs ^ this.maxIntervalMs >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OnChangeWithKeepAliveSubscriptionQos other = (OnChangeWithKeepAliveSubscriptionQos)((Object)obj);
        if (this.alertAfterIntervalMs != other.alertAfterIntervalMs) {
            return false;
        }
        return this.maxIntervalMs == other.maxIntervalMs;
    }
}

