/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import io.joynr.pubsub.SubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicSubscriptionQos
extends SubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PeriodicSubscriptionQos.class);
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private static final long MIN_PERIOD_MS = 50L;
    private static final long MAX_PERIOD_MS = 2592000000L;
    private static final long DEFAULT_PERIOD_MS = 60000L;
    private static final long MAX_ALERT_AFTER_INTERVAL_MS = 2592000000L;
    private static final long DEFAULT_ALERT_AFTER_INTERVAL_MS = 0L;
    private long periodMs = 60000L;
    private long alertAfterIntervalMs = 0L;

    public PeriodicSubscriptionQos() {
    }

    @Deprecated
    public PeriodicSubscriptionQos(long periodMs, long expiryDateMs, long alertAfterIntervalMs, long publicationTtlMs) {
        super(expiryDateMs, publicationTtlMs);
        this.setPeriodMs(periodMs);
        this.setAlertAfterIntervalMs(alertAfterIntervalMs);
    }

    @Deprecated
    public PeriodicSubscriptionQos(long periodMs, long expiryDateMs, long publicationTtlMs) {
        this(periodMs, expiryDateMs, 0L, publicationTtlMs);
    }

    @Deprecated
    public long getAlertAfterInterval() {
        return this.getAlertAfterIntervalMs();
    }

    public long getAlertAfterIntervalMs() {
        return this.alertAfterIntervalMs;
    }

    @Deprecated
    public PeriodicSubscriptionQos setAlertAfterInterval(long alertAfterIntervalMs) {
        return this.setAlertAfterIntervalMs(alertAfterIntervalMs);
    }

    public PeriodicSubscriptionQos setAlertAfterIntervalMs(long alertAfterIntervalMs) {
        if (alertAfterIntervalMs > 2592000000L) {
            this.alertAfterIntervalMs = 2592000000L;
            logger.warn("alertAfterInterval_ms > MAX_ALERT_AFTER_INTERVAL_MS. Using MAX_ALERT_AFTER_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.alertAfterIntervalMs = alertAfterIntervalMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.periodMs) {
            this.alertAfterIntervalMs = this.periodMs;
            logger.warn("alertAfterInterval_ms < MIN_ALERT_AFTER_INTERVAL and will therefore be set to the period: {}", (Object)this.periodMs);
        }
        return this;
    }

    public void clearAlertAfterInterval() {
        this.alertAfterIntervalMs = 0L;
    }

    @Deprecated
    public long getPeriod() {
        return this.getPeriodMs();
    }

    public long getPeriodMs() {
        return this.periodMs;
    }

    @Deprecated
    public PeriodicSubscriptionQos setPeriod(long periodMs) {
        return this.setPeriodMs(periodMs);
    }

    public PeriodicSubscriptionQos setPeriodMs(long periodMs) {
        if (periodMs < 50L) {
            this.periodMs = 50L;
            logger.warn("periodMs < MIN_PERIOD_MS. Using MIN_PERIOD_MS: {}", (Object)50L);
        } else if (periodMs > 2592000000L) {
            this.periodMs = 2592000000L;
            logger.warn("periodMs > MAX_PERIOD_MS. Using MAX_PERIOD_MS: {}", (Object)2592000000L);
        } else {
            this.periodMs = periodMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.periodMs) {
            this.alertAfterIntervalMs = this.periodMs;
            logger.warn("alertAfterIntervalMs < periodMs. Setting alertAfterIntervalMs = periodMs: {}", (Object)this.periodMs);
        }
        return this;
    }

    public PeriodicSubscriptionQos setExpiryDateMs(long expiryDateMs) {
        return (PeriodicSubscriptionQos)super.setExpiryDateMs(expiryDateMs);
    }

    public PeriodicSubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        return (PeriodicSubscriptionQos)super.setPublicationTtlMs(publicationTtlMs);
    }

    public PeriodicSubscriptionQos setValidityMs(long validityMs) {
        return (PeriodicSubscriptionQos)super.setValidityMs(validityMs);
    }

    @JsonIgnore
    @Deprecated
    public long getHeartbeat() {
        return this.periodMs;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.alertAfterIntervalMs ^ this.alertAfterIntervalMs >>> 32);
        result = 31 * result + (int)(this.periodMs ^ this.periodMs >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PeriodicSubscriptionQos other = (PeriodicSubscriptionQos)((Object)obj);
        if (this.alertAfterIntervalMs != other.alertAfterIntervalMs) {
            return false;
        }
        return this.periodMs == other.periodMs;
    }
}

