/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.pubsub;

import io.joynr.subtypes.JoynrType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionQos
implements JoynrType {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionQos.class);
    private long expiryDateMs = 0L;
    private long publicationTtlMs = 10000L;
    public static final int IGNORE_VALUE = -1;
    public static final long INFINITE_SUBSCRIPTION = Long.MAX_VALUE;
    private static final long MIN_PUBLICATION_TTL_MS = 100L;
    private static final long MAX_PUBLICATION_TTL_MS = 2592000000L;
    protected static final long DEFAULT_PUBLICATION_TTL_MS = 10000L;
    public static final long NO_EXPIRY_DATE = 0L;

    public SubscriptionQos() {
    }

    @Deprecated
    public SubscriptionQos(long expiryDateMs) {
        this(expiryDateMs, 10000L);
    }

    @Deprecated
    public SubscriptionQos(long expiryDateMs, long publicationTtlMs) {
        this.setExpiryDateMs(expiryDateMs);
        this.setPublicationTtlMs(publicationTtlMs);
    }

    @Deprecated
    public long getExpiryDate() {
        return this.getExpiryDateMs();
    }

    public long getExpiryDateMs() {
        return this.expiryDateMs;
    }

    @Deprecated
    public SubscriptionQos setExpiryDate(long expiryDateMs) {
        return this.setExpiryDateMs(expiryDateMs);
    }

    public SubscriptionQos setExpiryDateMs(long expiryDateMs) {
        long now = System.currentTimeMillis();
        if (expiryDateMs <= now && expiryDateMs != 0L) {
            throw new IllegalArgumentException("Subscription ExpiryDate " + expiryDateMs + " in the past. Now: " + now);
        }
        this.expiryDateMs = expiryDateMs;
        return this;
    }

    public SubscriptionQos setValidityMs(long validityMs) {
        if (validityMs == -1L) {
            this.setExpiryDateMs(0L);
        } else {
            long now = System.currentTimeMillis();
            this.expiryDateMs = now + validityMs;
        }
        return this;
    }

    @Deprecated
    public long getPublicationTtl() {
        return this.getPublicationTtlMs();
    }

    public long getPublicationTtlMs() {
        return this.publicationTtlMs;
    }

    @Deprecated
    public SubscriptionQos setPublicationTtl(long publicationTtlMs) {
        return this.setPublicationTtlMs(publicationTtlMs);
    }

    public SubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        if (publicationTtlMs < 100L) {
            this.publicationTtlMs = 100L;
            logger.warn("publicationTtlMs < MIN_PUBLICATION_TTL. Using MIN_PUBLICATION_TTL: {}", (Object)100L);
        } else if (publicationTtlMs > 2592000000L) {
            this.publicationTtlMs = 2592000000L;
            logger.warn("publicationTtlMs > MAX_PUBLICATION_TTL. Using MAX_PUBLICATION_TTL: {}", (Object)2592000000L);
        } else {
            this.publicationTtlMs = publicationTtlMs;
        }
        return this;
    }

    public void clearExpiryDate() {
        this.expiryDateMs = 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.expiryDateMs ^ this.expiryDateMs >>> 32);
        result = 31 * result + (int)(this.publicationTtlMs ^ this.publicationTtlMs >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionQos other = (SubscriptionQos)obj;
        if (this.expiryDateMs != other.expiryDateMs) {
            return false;
        }
        return this.publicationTtlMs == other.publicationTtlMs;
    }
}

