/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.AbstractSubscriptionPublisher;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.provider.SubscriptionPublisher;
import io.joynr.provider.SubscriptionPublisherInjection;

public class SubscriptionPublisherFactory {
    public AbstractSubscriptionPublisher create(Object provider) {
        String interfaceName = ProviderAnnotations.getInterfaceName(provider);
        String subscriptionPublisherClassName = "joynr." + interfaceName.replace("/", ".") + SubscriptionPublisher.class.getSimpleName();
        String subcriptionPublisherImplClassName = subscriptionPublisherClassName + "Impl";
        try {
            Class<?> subscriptionPublisherImplClass = Class.forName(subcriptionPublisherImplClassName);
            AbstractSubscriptionPublisher subscriptionPublisherImpl = (AbstractSubscriptionPublisher)subscriptionPublisherImplClass.newInstance();
            try {
                Class<?> subscriptionPublisherInjectionClass = Class.forName(subscriptionPublisherClassName + "Injection");
                if (subscriptionPublisherInjectionClass.isInstance(provider)) {
                    ((SubscriptionPublisherInjection)provider).setSubscriptionPublisher(subscriptionPublisherImpl);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return subscriptionPublisherImpl;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("For given provider of joynr interface \"" + interfaceName + "\", expected subscription publisher class of type \"" + subcriptionPublisherImplClassName + "\" could not be found by the classloader. Please ensure the class can be loaded.");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("For given provider of joynr interface \"" + interfaceName + "\", expected subscription publisher class of type \"" + subcriptionPublisherImplClassName + "\" could not be instantiated due to the following error: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("For given provider of joynr interface \"" + interfaceName + "\", expected subscription publisher class of type \"" + subcriptionPublisherImplClassName + "\" could not be accessed due to the following error: " + e.getMessage());
        }
    }
}

