/*
 * Decompiled with CFR 0.152.
 */
package joynr.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import joynr.types.ProviderQos;
import joynr.types.Version;

public class DiscoveryEntry
implements Serializable,
JoynrType {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 0;
    @JsonProperty(value="providerVersion")
    private Version providerVersion;
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="interfaceName")
    private String interfaceName;
    @JsonProperty(value="participantId")
    private String participantId;
    @JsonProperty(value="qos")
    private ProviderQos qos;
    @JsonProperty(value="lastSeenDateMs")
    private Long lastSeenDateMs;
    @JsonProperty(value="expiryDateMs")
    private Long expiryDateMs;
    @JsonProperty(value="publicKeyId")
    private String publicKeyId;

    public DiscoveryEntry() {
        this.providerVersion = new Version();
        this.domain = "";
        this.interfaceName = "";
        this.participantId = "";
        this.qos = new ProviderQos();
        this.lastSeenDateMs = 0L;
        this.expiryDateMs = 0L;
        this.publicKeyId = "";
    }

    public DiscoveryEntry(DiscoveryEntry discoveryEntryObj) {
        this.providerVersion = new Version(discoveryEntryObj.providerVersion);
        this.domain = discoveryEntryObj.domain;
        this.interfaceName = discoveryEntryObj.interfaceName;
        this.participantId = discoveryEntryObj.participantId;
        this.qos = new ProviderQos(discoveryEntryObj.qos);
        this.lastSeenDateMs = discoveryEntryObj.lastSeenDateMs;
        this.expiryDateMs = discoveryEntryObj.expiryDateMs;
        this.publicKeyId = discoveryEntryObj.publicKeyId;
    }

    public DiscoveryEntry(Version providerVersion, String domain, String interfaceName, String participantId, ProviderQos qos, Long lastSeenDateMs, Long expiryDateMs, String publicKeyId) {
        this.providerVersion = providerVersion;
        this.domain = domain;
        this.interfaceName = interfaceName;
        this.participantId = participantId;
        this.qos = qos;
        this.lastSeenDateMs = lastSeenDateMs;
        this.expiryDateMs = expiryDateMs;
        this.publicKeyId = publicKeyId;
    }

    @JsonIgnore
    public Version getProviderVersion() {
        return this.providerVersion;
    }

    @JsonIgnore
    public void setProviderVersion(Version providerVersion) {
        this.providerVersion = providerVersion;
    }

    @JsonIgnore
    public String getDomain() {
        return this.domain;
    }

    @JsonIgnore
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonIgnore
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @JsonIgnore
    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @JsonIgnore
    public String getParticipantId() {
        return this.participantId;
    }

    @JsonIgnore
    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    @JsonIgnore
    public ProviderQos getQos() {
        return this.qos;
    }

    @JsonIgnore
    public void setQos(ProviderQos qos) {
        this.qos = qos;
    }

    @JsonIgnore
    public Long getLastSeenDateMs() {
        return this.lastSeenDateMs;
    }

    @JsonIgnore
    public void setLastSeenDateMs(Long lastSeenDateMs) {
        this.lastSeenDateMs = lastSeenDateMs;
    }

    @JsonIgnore
    public Long getExpiryDateMs() {
        return this.expiryDateMs;
    }

    @JsonIgnore
    public void setExpiryDateMs(Long expiryDateMs) {
        this.expiryDateMs = expiryDateMs;
    }

    @JsonIgnore
    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    @JsonIgnore
    public void setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
    }

    public String toString() {
        return "DiscoveryEntry [providerVersion=" + this.providerVersion + ", " + "domain=" + this.domain + ", " + "interfaceName=" + this.interfaceName + ", " + "participantId=" + this.participantId + ", " + "qos=" + this.qos + ", " + "lastSeenDateMs=" + this.lastSeenDateMs + ", " + "expiryDateMs=" + this.expiryDateMs + ", " + "publicKeyId=" + this.publicKeyId + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryEntry other = (DiscoveryEntry)obj;
        if (this.providerVersion == null ? other.providerVersion != null : !this.providerVersion.equals(other.providerVersion)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId)) {
            return false;
        }
        if (this.qos == null ? other.qos != null : !this.qos.equals(other.qos)) {
            return false;
        }
        if (this.lastSeenDateMs == null ? other.lastSeenDateMs != null : !this.lastSeenDateMs.equals(other.lastSeenDateMs)) {
            return false;
        }
        if (this.expiryDateMs == null ? other.expiryDateMs != null : !this.expiryDateMs.equals(other.expiryDateMs)) {
            return false;
        }
        return !(this.publicKeyId == null ? other.publicKeyId != null : !this.publicKeyId.equals(other.publicKeyId));
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = 31 * result + (this.providerVersion == null ? 0 : this.providerVersion.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.qos == null ? 0 : this.qos.hashCode());
        result = 31 * result + (this.lastSeenDateMs == null ? 0 : this.lastSeenDateMs.hashCode());
        result = 31 * result + (this.expiryDateMs == null ? 0 : this.expiryDateMs.hashCode());
        result = 31 * result + (this.publicKeyId == null ? 0 : this.publicKeyId.hashCode());
        return result;
    }
}

