/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.exceptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.exceptions.JoynrRuntimeException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JoynrTimeoutException
extends JoynrRuntimeException {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<DateFormat> DateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd/MM HH:mm:ss:sss");
        }
    };
    @JsonProperty
    private long expiryDate;

    protected JoynrTimeoutException() {
    }

    public JoynrTimeoutException(long expiryDate) {
        super("ttl expired on: " + DateFormatter.get().format(expiryDate));
        this.expiryDate = expiryDate;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.expiryDate ^ this.expiryDate >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrTimeoutException other = (JoynrTimeoutException)obj;
        return this.expiryDate == other.expiryDate;
    }
}

