/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.JoynrProvider;
import io.joynr.pubsub.publication.AttributeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJoynrProvider
implements JoynrProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJoynrProvider.class);
    ConcurrentHashMap<String, List<AttributeListener>> attributeListeners = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAttributeValueChanged(String attributeName, Object value) {
        List<AttributeListener> listeners;
        if (!this.attributeListeners.containsKey(attributeName)) {
            return;
        }
        List<AttributeListener> list = listeners = this.attributeListeners.get(attributeName);
        synchronized (list) {
            for (AttributeListener listener : listeners) {
                listener.attributeValueChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAttributeListener(String attributeName, AttributeListener attributeListener) {
        List<AttributeListener> listeners;
        this.attributeListeners.putIfAbsent(attributeName, new ArrayList());
        List<AttributeListener> list = listeners = this.attributeListeners.get(attributeName);
        synchronized (list) {
            listeners.add(attributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAttributeListener(String attributeName, AttributeListener attributeListener) {
        List<AttributeListener> listeners = this.attributeListeners.get(attributeName);
        if (listeners == null) {
            LOG.error("trying to unregister an attribute listener for attribute \"" + attributeName + "\" that was never registered");
            return;
        }
        List<AttributeListener> list = listeners;
        synchronized (list) {
            boolean success = listeners.remove(attributeListener);
            if (!success) {
                LOG.error("trying to unregister an attribute listener for attribute \"" + attributeName + "\" that was never registered");
                return;
            }
        }
    }
}

