/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import io.joynr.dispatcher.rpc.RequestStatus;
import io.joynr.dispatcher.rpc.RequestStatusCode;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrWaitExpiredException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Future<T> {
    private T reply;
    private JoynrException exception = null;
    RequestStatus status = new RequestStatus(RequestStatusCode.IN_PROGRESS);
    private Lock statusLock = new ReentrantLock();
    private Condition statusLockChangedCondition = this.statusLock.newCondition();

    public T getReply(long timeout_ms) throws InterruptedException, JoynrWaitExpiredException {
        try {
            this.statusLock.lock();
            if (this.status.getCode() == RequestStatusCode.OK) {
                T t = this.reply;
                return t;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            boolean awaitOk = this.statusLockChangedCondition.await(timeout_ms, TimeUnit.MILLISECONDS);
            if (this.exception != null) {
                throw this.exception;
            }
            if (!awaitOk) {
                this.status.setCode(RequestStatusCode.ERROR);
                throw new JoynrWaitExpiredException();
            }
            T t = this.reply;
            return t;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public T getReply() throws InterruptedException {
        return this.getReply(Long.MAX_VALUE);
    }

    public RequestStatus getStatus() {
        return this.status;
    }

    public void onSuccess(T result) {
        try {
            try {
                this.statusLock.lock();
                this.reply = result;
                this.statusLockChangedCondition.signal();
                this.status = new RequestStatus(RequestStatusCode.OK);
            }
            catch (Throwable e) {
                this.status = new RequestStatus(RequestStatusCode.ERROR);
                this.exception = new JoynrException(e);
                this.statusLock.unlock();
            }
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void onFailure(JoynrException newException) {
        this.exception = newException;
        this.status = new RequestStatus(RequestStatusCode.ERROR);
        try {
            this.statusLock.lock();
            this.statusLockChangedCondition.signal();
        }
        finally {
            this.statusLock.unlock();
        }
    }
}

