/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.exceptions.JoynrException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrUtil {
    private static final Logger logger = LoggerFactory.getLogger(JoynrUtil.class);

    public static String getStringFromOS(OS os) {
        if (os == OS.WIN32) {
            return "win32";
        }
        if (os == OS.LINUX) {
            return "linux";
        }
        if (os == OS.TEST) {
            return "test";
        }
        return "undefined";
    }

    @CheckForNull
    public static Properties loadProperties(File file) throws IOException {
        if (file != null) {
            if (!file.isDirectory()) {
                FileInputStream inputStream = new FileInputStream(file);
                return JoynrUtil.loadProperties(inputStream);
            }
            return JoynrUtil.loadPropertyDirectory(file);
        }
        return null;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static File createDir(String dirName) {
        File tempDir = new File(dirName);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            logger.debug("Creating of dir " + dirName + " failed.");
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static File createTempDir(String dirName) {
        return JoynrUtil.createDir(String.valueOf(JoynrUtil.getBaseTempPath()) + File.separator + dirName);
    }

    public static String getBaseTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTempDir() {
        Random rand = new Random();
        int randomInt = 1 + rand.nextInt();
        return JoynrUtil.createTempDir("tempDir" + randomInt);
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                logger.debug("Creating target directory " + targetLocation + " failed.");
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                JoynrUtil.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceLocation);
                out = new FileOutputStream(targetLocation);
                JoynrUtil.copyStream(in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static Properties loadPropertyDirectory(File dir) throws IOException {
        Properties returnValue = new Properties();
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith("properties")) {
                    FileInputStream inputStream = new FileInputStream(file);
                    JoynrUtil.loadProperties(inputStream, returnValue);
                }
                ++n2;
            }
        }
        return returnValue;
    }

    public static Properties loadProperties(InputStream configInputStream) throws IOException {
        return JoynrUtil.loadProperties(configInputStream, null);
    }

    public static Properties loadProperties(InputStream configInputStream, @CheckForNull Properties properties) throws IOException {
        if (configInputStream != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.load(configInputStream);
            configInputStream.close();
            return properties;
        }
        return properties;
    }

    public static OS getOSFromString(String os) {
        if (os.equalsIgnoreCase("win32")) {
            return OS.WIN32;
        }
        if (os.equalsIgnoreCase("linux")) {
            return OS.LINUX;
        }
        if (os.equalsIgnoreCase("test")) {
            return OS.TEST;
        }
        return OS.UNDEFINED;
    }

    public static void copyDirectoryFromJar(String jarName, String srcDir, File tmpDir) throws IOException {
        JarFile jf = null;
        ZipInputStream jarInputStream = null;
        try {
            try {
                jf = new JarFile(jarName);
                JarEntry je = jf.getJarEntry(srcDir);
                if (je.isDirectory()) {
                    FileInputStream fis = new FileInputStream(jarName);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    jarInputStream = new JarInputStream(bis);
                    JarEntry ze = null;
                    while ((ze = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                        if (ze.isDirectory() || !ze.getName().contains(je.getName())) continue;
                        InputStream is = jf.getInputStream(ze);
                        String name = ze.getName().substring(ze.getName().lastIndexOf("/") + 1);
                        File tmpFile = new File(tmpDir + "/" + name);
                        tmpFile.deleteOnExit();
                        FileOutputStream outputStreamRuntime = new FileOutputStream(tmpFile);
                        JoynrUtil.copyStream(is, outputStreamRuntime);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (jf != null) {
                    jf.close();
                }
                if (jarInputStream != null) {
                    jarInputStream.close();
                }
            }
        }
        finally {
            if (jf != null) {
                jf.close();
            }
            if (jarInputStream != null) {
                jarInputStream.close();
            }
        }
    }

    public static void checkConnectivity(String host) throws IOException {
        InetAddress headUnitAddr = InetAddress.getByName(host);
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (!headUnitAddr.isReachable(iface, 0, 5000)) continue;
            return;
        }
        throw new UnknownHostException("Connectivity check to the host \"" + host + "\" has failed");
    }

    public static Byte[] getResourceAsByteArray(InputStream inputStream) {
        return (Byte[])JoynrUtil.getResource(inputStream, true);
    }

    public static String getResourceAsString(InputStream inputStream) {
        return (String)JoynrUtil.getResource(inputStream, false);
    }

    public static Byte[] getResourceAsByteArray(String fileName) {
        return (Byte[])JoynrUtil.getResource(JoynrUtil.class.getResourceAsStream(fileName), true);
    }

    public static String getResourceAsString(String fileName) {
        return (String)JoynrUtil.getResource(JoynrUtil.class.getResourceAsStream(fileName), false);
    }

    public static void writeResource(String stringResource, String fileName) throws IOException {
        JoynrUtil.writeResource(stringResource.getBytes("UTF-8"), fileName);
    }

    public static void writeResource(Byte[] byteResource, String fileName) throws IOException {
        JoynrUtil.writeResource(ArrayUtils.toPrimitive((Byte[])byteResource), fileName);
    }

    public static void writeResource(byte[] byteResource, String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            JoynrUtil.createDir(file.getParentFile().getAbsolutePath());
        }
        if (!file.createNewFile()) {
            logger.debug("Creating file " + fileName + " failed.");
        }
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(fileName);
                outputStream.write(byteResource);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static Object getResource(InputStream inputStream, boolean asByteArray) throws JoynrException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[512];
        try {
            int readBytes;
            while ((readBytes = inputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, readBytes);
            }
            Object result = null;
            result = asByteArray ? ArrayUtils.toObject((byte[])outputStream.toByteArray()) : outputStream.toString("UTF-8");
            inputStream.close();
            outputStream.close();
            return result;
        }
        catch (IOException e) {
            throw new JoynrException(e.getMessage(), e){
                private static final long serialVersionUID = 1L;
            };
        }
    }

    public static enum OS {
        LINUX,
        WIN32,
        TEST,
        UNDEFINED;

    }
}

