/*
 * Decompiled with CFR 0.152.
 */
package joynr.system;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.system.CommunicationMiddleware;
import joynr.types.ProviderQos;

public class DiscoveryEntry
implements Serializable,
JoynrType {
    private String interfaceName;
    private String domain;
    private ProviderQos qos;
    private String participantId;
    private List<CommunicationMiddleware> connections = Lists.newArrayList();
    private Boolean global;

    public DiscoveryEntry() {
        this.interfaceName = "";
        this.domain = "";
        this.qos = new ProviderQos();
        this.participantId = "";
        this.connections = new ArrayList<CommunicationMiddleware>();
        this.global = false;
    }

    public DiscoveryEntry(String interfaceName, String domain, ProviderQos qos, String participantId, List<CommunicationMiddleware> connections, Boolean global) {
        this.interfaceName = interfaceName;
        this.domain = domain;
        this.qos = qos;
        this.participantId = participantId;
        this.connections = connections;
        this.global = global;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ProviderQos getQos() {
        return this.qos;
    }

    public void setQos(ProviderQos qos) {
        this.qos = qos;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public List<CommunicationMiddleware> getConnections() {
        return this.connections;
    }

    public void setConnections(List<CommunicationMiddleware> connections) {
        this.connections = connections;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public String toString() {
        return "DiscoveryEntry [interfaceName=" + this.interfaceName + ", " + "domain=" + this.domain + ", " + "qos=" + this.qos + ", " + "participantId=" + this.participantId + ", " + "connections=" + this.connections + ", " + "global=" + this.global + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryEntry other = (DiscoveryEntry)obj;
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.qos == null ? other.qos != null : !this.qos.equals(other.qos)) {
            return false;
        }
        if (this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId)) {
            return false;
        }
        if (this.connections == null ? other.connections != null : !this.connections.equals(other.connections)) {
            return false;
        }
        return !(this.global == null ? other.global != null : !this.global.equals(other.global));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.qos == null ? 0 : this.qos.hashCode());
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.connections == null ? 0 : this.connections.hashCode());
        result = 31 * result + (this.global == null ? 0 : this.global.hashCode());
        return result;
    }
}

