/*
 * Decompiled with CFR 0.152.
 */
package joynr.system;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.system.JoynrLogLevel;
import joynr.system.JoynrLoggedException;
import joynr.system.JoynrLoggingContextTag;

public class JoynrLogEvent
implements Serializable,
JoynrType {
    private Long timestamp;
    private String eventVersion;
    private String host;
    private String path;
    private String message;
    private JoynrLogLevel priority;
    private JoynrLoggedException exception;
    private List<JoynrLoggingContextTag> tags = Lists.newArrayList();

    public JoynrLogEvent() {
        this.timestamp = 0L;
        this.eventVersion = "";
        this.host = "";
        this.path = "";
        this.message = "";
        this.priority = JoynrLogLevel.OFF;
        this.exception = new JoynrLoggedException();
        this.tags = new ArrayList<JoynrLoggingContextTag>();
    }

    public JoynrLogEvent(Long timestamp, String eventVersion, String host, String path, String message, JoynrLogLevel priority, JoynrLoggedException exception, List<JoynrLoggingContextTag> tags) {
        this.timestamp = timestamp;
        this.eventVersion = eventVersion;
        this.host = host;
        this.path = path;
        this.message = message;
        this.priority = priority;
        this.exception = exception;
        this.tags = tags;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getEventVersion() {
        return this.eventVersion;
    }

    public void setEventVersion(String eventVersion) {
        this.eventVersion = eventVersion;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public JoynrLogLevel getPriority() {
        return this.priority;
    }

    public void setPriority(JoynrLogLevel priority) {
        this.priority = priority;
    }

    public JoynrLoggedException getException() {
        return this.exception;
    }

    public void setException(JoynrLoggedException exception) {
        this.exception = exception;
    }

    public List<JoynrLoggingContextTag> getTags() {
        return this.tags;
    }

    public void setTags(List<JoynrLoggingContextTag> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "JoynrLogEvent [timestamp=" + this.timestamp + ", " + "eventVersion=" + this.eventVersion + ", " + "host=" + this.host + ", " + "path=" + this.path + ", " + "message=" + this.message + ", " + "priority=" + (Object)((Object)this.priority) + ", " + "exception=" + this.exception + ", " + "tags=" + this.tags + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrLogEvent other = (JoynrLogEvent)obj;
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.eventVersion == null ? other.eventVersion != null : !this.eventVersion.equals(other.eventVersion)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals((Object)other.priority)) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.equals(other.exception)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.eventVersion == null ? 0 : this.eventVersion.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }
}

