/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import joynr.OnChangeSubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnChangeWithKeepAliveSubscriptionQos
extends OnChangeSubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final Logger logger = LoggerFactory.getLogger(OnChangeWithKeepAliveSubscriptionQos.class);
    private static final long MIN_MAX_INTERVAL = 50L;
    private static final long MAX_MAX_INTERVAL = 2592000000L;
    private static final long MAX_ALERT_AFTER_INTERVAL = 2592000000L;
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private static final long DEFAULT_ALERT_AFTER_INTERVAL = 0L;
    private long maxInterval;
    private long alertAfterInterval;

    protected OnChangeWithKeepAliveSubscriptionQos() {
    }

    public OnChangeWithKeepAliveSubscriptionQos(long minInterval_ms, long maxInterval_ms, long expiryDate) {
        this(minInterval_ms, maxInterval_ms, expiryDate, 0L, 10000L);
    }

    public OnChangeWithKeepAliveSubscriptionQos(long minInterval_ms, long maxInterval_ms, long expiryDate, long alertAfterInterval_ms) {
        this(minInterval_ms, maxInterval_ms, expiryDate, alertAfterInterval_ms, 10000L);
    }

    public OnChangeWithKeepAliveSubscriptionQos(long minInterval_ms, long maxInterval_ms, long expiryDate_ms, long alertAfterInterval_ms, long publicationTtl_ms) {
        super(minInterval_ms, expiryDate_ms, publicationTtl_ms);
        this.setMaxInterval(maxInterval_ms);
        this.setAlertAfterInterval(alertAfterInterval_ms);
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(long maxInterval_ms) {
        if (maxInterval_ms < this.getMinInterval()) {
            maxInterval_ms = this.getMinInterval();
        }
        if (maxInterval_ms < 50L) {
            this.maxInterval = 50L;
            return;
        }
        if (maxInterval_ms > 2592000000L) {
            this.maxInterval = 2592000000L;
            return;
        }
        this.maxInterval = maxInterval_ms;
    }

    public long getAlertAfterInterval() {
        return this.alertAfterInterval;
    }

    public void setAlertAfterInterval(long alertAfterInterval_ms) {
        if (alertAfterInterval_ms < this.maxInterval) {
            this.alertAfterInterval = 0L;
            logger.warn("alertAfterInterval_ms < maxInterval. AlertAfter deactivated");
            return;
        }
        if (alertAfterInterval_ms > 2592000000L) {
            this.alertAfterInterval = 2592000000L;
            logger.warn("alertAfterInterval_ms > maxInterval. Using MAX_ALERT_AFTER_INTERVAL: {}", (Object)2592000000L);
            return;
        }
        this.alertAfterInterval = alertAfterInterval_ms;
    }

    @JsonIgnore
    public long getHeartbeat() {
        return this.maxInterval;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.alertAfterInterval ^ this.alertAfterInterval >>> 32);
        result = 31 * result + (int)(this.maxInterval ^ this.maxInterval >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OnChangeWithKeepAliveSubscriptionQos other = (OnChangeWithKeepAliveSubscriptionQos)((Object)obj);
        if (this.alertAfterInterval != other.alertAfterInterval) {
            return false;
        }
        return this.maxInterval == other.maxInterval;
    }
}

