/*
 * Decompiled with CFR 0.152.
 */
package joynr.system;

import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import joynr.system.Address;
import joynr.system.WebSocketProtocol;

public class WebSocketAddress
extends Address
implements Serializable,
JoynrType {
    private WebSocketProtocol protocol;
    private String host;
    private Integer port;
    private String path;

    public WebSocketAddress() {
        this.protocol = WebSocketProtocol.WS;
        this.host = "";
        this.port = 0;
        this.path = "";
    }

    public WebSocketAddress(WebSocketAddress webSocketAddressObj) {
        super(webSocketAddressObj);
        this.protocol = webSocketAddressObj.protocol;
        this.host = webSocketAddressObj.host;
        this.port = webSocketAddressObj.port;
        this.path = webSocketAddressObj.path;
    }

    public WebSocketAddress(WebSocketProtocol protocol, String host, Integer port, String path) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(WebSocketProtocol protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        return "WebSocketAddress [" + super.toString() + ", " + "protocol=" + (Object)((Object)this.protocol) + ", " + "host=" + this.host + ", " + "port=" + this.port + ", " + "path=" + this.path + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        WebSocketAddress other = (WebSocketAddress)obj;
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }
}

