/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import io.joynr.dispatcher.rpc.RequestStatus;
import io.joynr.dispatcher.rpc.RequestStatusCode;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrWaitExpiredException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Future<T> {
    private T reply;
    private JoynrRuntimeException exception = null;
    RequestStatus status = new RequestStatus(RequestStatusCode.IN_PROGRESS);
    private Lock statusLock = new ReentrantLock();
    private Condition statusLockChangedCondition = this.statusLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getReply(long timeout_ms) throws InterruptedException, JoynrWaitExpiredException {
        try {
            this.statusLock.lock();
            if (this.status.getCode() == RequestStatusCode.OK) {
                T t = this.reply;
                return t;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            boolean awaitOk = this.statusLockChangedCondition.await(timeout_ms, TimeUnit.MILLISECONDS);
            if (this.exception != null) {
                throw this.exception;
            }
            if (!awaitOk) {
                this.status.setCode(RequestStatusCode.ERROR);
                throw new JoynrWaitExpiredException();
            }
            T t = this.reply;
            return t;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public T getReply() throws InterruptedException {
        return this.getReply(Long.MAX_VALUE);
    }

    public RequestStatus getStatus() {
        return this.status;
    }

    public void onSuccess(T result) {
        try {
            this.statusLock.lock();
            this.reply = result;
            this.status = new RequestStatus(RequestStatusCode.OK);
            this.statusLockChangedCondition.signalAll();
        }
        catch (Throwable e) {
            this.status = new RequestStatus(RequestStatusCode.ERROR);
            this.exception = new JoynrRuntimeException(e);
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void onFailure(JoynrRuntimeException newException) {
        this.exception = newException;
        this.status = new RequestStatus(RequestStatusCode.ERROR);
        try {
            this.statusLock.lock();
            this.statusLockChangedCondition.signalAll();
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void resolve(Object ... response) {
        if (response.length == 0) {
            this.onSuccess(null);
        } else if (response[0] instanceof JoynrRuntimeException) {
            this.onFailure((JoynrRuntimeException)response[0]);
        } else {
            this.onSuccess(response[0]);
        }
    }
}

