/*
 * Decompiled with CFR 0.152.
 */
package joynr.infrastructure.dactypes;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.infrastructure.dactypes.ControlEntry;
import joynr.infrastructure.dactypes.TrustLevel;

public class MasterControlEntry
extends ControlEntry
implements Serializable,
JoynrType {
    private TrustLevel defaultRequiredTrustLevel;
    private List<TrustLevel> possibleRequiredTrustLevels = Lists.newArrayList();
    private TrustLevel defaultRequiredControlEntryChangeTrustLevel;
    private List<TrustLevel> possibleRequiredControlEntryChangeTrustLevels = Lists.newArrayList();

    public MasterControlEntry() {
        this.defaultRequiredTrustLevel = TrustLevel.HIGH;
        this.possibleRequiredTrustLevels = new ArrayList<TrustLevel>();
        this.defaultRequiredControlEntryChangeTrustLevel = TrustLevel.HIGH;
        this.possibleRequiredControlEntryChangeTrustLevels = new ArrayList<TrustLevel>();
    }

    public MasterControlEntry(MasterControlEntry masterControlEntryObj) {
        super(masterControlEntryObj);
        this.defaultRequiredTrustLevel = masterControlEntryObj.defaultRequiredTrustLevel;
        this.possibleRequiredTrustLevels = new ArrayList<TrustLevel>(masterControlEntryObj.possibleRequiredTrustLevels);
        this.defaultRequiredControlEntryChangeTrustLevel = masterControlEntryObj.defaultRequiredControlEntryChangeTrustLevel;
        this.possibleRequiredControlEntryChangeTrustLevels = new ArrayList<TrustLevel>(masterControlEntryObj.possibleRequiredControlEntryChangeTrustLevels);
    }

    public MasterControlEntry(String uid, String domain, String interfaceName, TrustLevel defaultRequiredTrustLevel, List<TrustLevel> possibleRequiredTrustLevels, TrustLevel defaultRequiredControlEntryChangeTrustLevel, List<TrustLevel> possibleRequiredControlEntryChangeTrustLevels) {
        super(uid, domain, interfaceName);
        this.defaultRequiredTrustLevel = defaultRequiredTrustLevel;
        this.possibleRequiredTrustLevels = possibleRequiredTrustLevels;
        this.defaultRequiredControlEntryChangeTrustLevel = defaultRequiredControlEntryChangeTrustLevel;
        this.possibleRequiredControlEntryChangeTrustLevels = possibleRequiredControlEntryChangeTrustLevels;
    }

    public TrustLevel getDefaultRequiredTrustLevel() {
        return this.defaultRequiredTrustLevel;
    }

    public void setDefaultRequiredTrustLevel(TrustLevel defaultRequiredTrustLevel) {
        this.defaultRequiredTrustLevel = defaultRequiredTrustLevel;
    }

    public List<TrustLevel> getPossibleRequiredTrustLevels() {
        return this.possibleRequiredTrustLevels;
    }

    public void setPossibleRequiredTrustLevels(List<TrustLevel> possibleRequiredTrustLevels) {
        this.possibleRequiredTrustLevels = possibleRequiredTrustLevels;
    }

    public TrustLevel getDefaultRequiredControlEntryChangeTrustLevel() {
        return this.defaultRequiredControlEntryChangeTrustLevel;
    }

    public void setDefaultRequiredControlEntryChangeTrustLevel(TrustLevel defaultRequiredControlEntryChangeTrustLevel) {
        this.defaultRequiredControlEntryChangeTrustLevel = defaultRequiredControlEntryChangeTrustLevel;
    }

    public List<TrustLevel> getPossibleRequiredControlEntryChangeTrustLevels() {
        return this.possibleRequiredControlEntryChangeTrustLevels;
    }

    public void setPossibleRequiredControlEntryChangeTrustLevels(List<TrustLevel> possibleRequiredControlEntryChangeTrustLevels) {
        this.possibleRequiredControlEntryChangeTrustLevels = possibleRequiredControlEntryChangeTrustLevels;
    }

    @Override
    public String toString() {
        return "MasterControlEntry [" + super.toString() + ", " + "defaultRequiredTrustLevel=" + (Object)((Object)this.defaultRequiredTrustLevel) + ", " + "possibleRequiredTrustLevels=" + this.possibleRequiredTrustLevels + ", " + "defaultRequiredControlEntryChangeTrustLevel=" + (Object)((Object)this.defaultRequiredControlEntryChangeTrustLevel) + ", " + "possibleRequiredControlEntryChangeTrustLevels=" + this.possibleRequiredControlEntryChangeTrustLevels + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MasterControlEntry other = (MasterControlEntry)obj;
        if (this.defaultRequiredTrustLevel == null ? other.defaultRequiredTrustLevel != null : !this.defaultRequiredTrustLevel.equals((Object)other.defaultRequiredTrustLevel)) {
            return false;
        }
        if (this.possibleRequiredTrustLevels == null ? other.possibleRequiredTrustLevels != null : !this.possibleRequiredTrustLevels.equals(other.possibleRequiredTrustLevels)) {
            return false;
        }
        if (this.defaultRequiredControlEntryChangeTrustLevel == null ? other.defaultRequiredControlEntryChangeTrustLevel != null : !this.defaultRequiredControlEntryChangeTrustLevel.equals((Object)other.defaultRequiredControlEntryChangeTrustLevel)) {
            return false;
        }
        return !(this.possibleRequiredControlEntryChangeTrustLevels == null ? other.possibleRequiredControlEntryChangeTrustLevels != null : !this.possibleRequiredControlEntryChangeTrustLevels.equals(other.possibleRequiredControlEntryChangeTrustLevels));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.defaultRequiredTrustLevel == null ? 0 : this.defaultRequiredTrustLevel.hashCode());
        result = 31 * result + (this.possibleRequiredTrustLevels == null ? 0 : this.possibleRequiredTrustLevels.hashCode());
        result = 31 * result + (this.defaultRequiredControlEntryChangeTrustLevel == null ? 0 : this.defaultRequiredControlEntryChangeTrustLevel.hashCode());
        result = 31 * result + (this.possibleRequiredControlEntryChangeTrustLevels == null ? 0 : this.possibleRequiredControlEntryChangeTrustLevels.hashCode());
        return result;
    }
}

