/*
 * Decompiled with CFR 0.152.
 */
package joynr.infrastructure.dactypes;

import com.google.common.collect.Lists;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import joynr.infrastructure.dactypes.MasterControlEntry;
import joynr.infrastructure.dactypes.Permission;
import joynr.infrastructure.dactypes.TrustLevel;

public class MasterRegistrationControlEntry
extends MasterControlEntry
implements Serializable,
JoynrType {
    private Permission defaultProviderPermission;
    private List<Permission> possibleProviderPermissions = Lists.newArrayList();

    public MasterRegistrationControlEntry() {
        this.defaultProviderPermission = Permission.YES;
        this.possibleProviderPermissions = new ArrayList<Permission>();
    }

    public MasterRegistrationControlEntry(MasterRegistrationControlEntry masterRegistrationControlEntryObj) {
        super(masterRegistrationControlEntryObj);
        this.defaultProviderPermission = masterRegistrationControlEntryObj.defaultProviderPermission;
        this.possibleProviderPermissions = new ArrayList<Permission>(masterRegistrationControlEntryObj.possibleProviderPermissions);
    }

    public MasterRegistrationControlEntry(String uid, String domain, String interfaceName, TrustLevel defaultRequiredTrustLevel, List<TrustLevel> possibleRequiredTrustLevels, TrustLevel defaultRequiredControlEntryChangeTrustLevel, List<TrustLevel> possibleRequiredControlEntryChangeTrustLevels, Permission defaultProviderPermission, List<Permission> possibleProviderPermissions) {
        super(uid, domain, interfaceName, defaultRequiredTrustLevel, possibleRequiredTrustLevels, defaultRequiredControlEntryChangeTrustLevel, possibleRequiredControlEntryChangeTrustLevels);
        this.defaultProviderPermission = defaultProviderPermission;
        this.possibleProviderPermissions = possibleProviderPermissions;
    }

    public Permission getDefaultProviderPermission() {
        return this.defaultProviderPermission;
    }

    public void setDefaultProviderPermission(Permission defaultProviderPermission) {
        this.defaultProviderPermission = defaultProviderPermission;
    }

    public List<Permission> getPossibleProviderPermissions() {
        return this.possibleProviderPermissions;
    }

    public void setPossibleProviderPermissions(List<Permission> possibleProviderPermissions) {
        this.possibleProviderPermissions = possibleProviderPermissions;
    }

    @Override
    public String toString() {
        return "MasterRegistrationControlEntry [" + super.toString() + ", " + "defaultProviderPermission=" + (Object)((Object)this.defaultProviderPermission) + ", " + "possibleProviderPermissions=" + this.possibleProviderPermissions + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MasterRegistrationControlEntry other = (MasterRegistrationControlEntry)obj;
        if (this.defaultProviderPermission == null ? other.defaultProviderPermission != null : !this.defaultProviderPermission.equals((Object)other.defaultProviderPermission)) {
            return false;
        }
        return !(this.possibleProviderPermissions == null ? other.possibleProviderPermissions != null : !this.possibleProviderPermissions.equals(other.possibleProviderPermissions));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.defaultProviderPermission == null ? 0 : this.defaultProviderPermission.hashCode());
        result = 31 * result + (this.possibleProviderPermissions == null ? 0 : this.possibleProviderPermissions.hashCode());
        return result;
    }
}

