/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class AnnotationUtil {
    public static Collection<Annotation> getAnnotationsRecursive(Class<?> clazz) {
        HashSet<Annotation> allAnnotations = new HashSet<Annotation>();
        AnnotationUtil.getAllAnnotations(clazz, allAnnotations);
        return allAnnotations;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        Iterable allAnnotations = Iterables.filter(AnnotationUtil.getAnnotationsRecursive(clazz), annotationType);
        if (allAnnotations.iterator().hasNext()) {
            return (T)((Annotation)allAnnotations.iterator().next());
        }
        return null;
    }

    private static void getAllAnnotations(Class<?> clazz, Collection<Annotation> result) {
        if (clazz == null) {
            return;
        }
        result.addAll(Arrays.asList(clazz.getDeclaredAnnotations()));
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            AnnotationUtil.getAllAnnotations(interfaceClass, result);
        }
        AnnotationUtil.getAllAnnotations(clazz.getSuperclass(), result);
    }
}

