/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredListener;
import io.joynr.provider.PromiseListener;
import java.util.ArrayList;
import java.util.List;

public class Promise<T extends AbstractDeferred> {
    private T deferred;
    private List<PromiseListener> listeners = new ArrayList<PromiseListener>();

    public Promise(T deferred) {
        this.deferred = deferred;
        ((AbstractDeferred)this.deferred).addListener(new DeferredListener(){

            @Override
            public void onSettlement() {
                Promise.this.notifyListeners();
            }
        });
    }

    public void then(PromiseListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
        if (this.isSettled()) {
            this.notifyListener(listener);
        }
    }

    private void notifyListeners() {
        for (PromiseListener listener : this.listeners) {
            this.notifyListener(listener);
        }
    }

    private void notifyListener(PromiseListener listener) {
        if (this.isFulfilled()) {
            listener.onFulfillment(((AbstractDeferred)this.deferred).getValues());
        } else if (this.isRejected()) {
            listener.onRejection(((AbstractDeferred)this.deferred).getError());
        }
    }

    public boolean isFulfilled() {
        return ((AbstractDeferred)this.deferred).isFulfilled();
    }

    public boolean isRejected() {
        return ((AbstractDeferred)this.deferred).isRejected();
    }

    public boolean isSettled() {
        return ((AbstractDeferred)this.deferred).isSettled();
    }
}

