/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrUtil {
    private static final Logger logger = LoggerFactory.getLogger(JoynrUtil.class);
    private static final Base64.Encoder base64Encoder = Base64.getUrlEncoder().withoutPadding();

    public static String getStringFromOS(OS os) {
        if (os == OS.WIN32) {
            return "win32";
        }
        if (os == OS.LINUX) {
            return "linux";
        }
        if (os == OS.TEST) {
            return "test";
        }
        return "undefined";
    }

    public static Properties loadProperties(Optional<File> file) throws IOException {
        if (file.isPresent()) {
            File actualFile = file.get();
            if (!actualFile.isDirectory()) {
                FileInputStream inputStream = new FileInputStream(actualFile);
                return JoynrUtil.loadProperties(inputStream);
            }
            return JoynrUtil.loadPropertyDirectory(actualFile);
        }
        return null;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static File createDir(String dirName) {
        File tempDir = new File(dirName);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            logger.debug("Creating of dir " + dirName + " failed.");
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static File createTempDir(String dirName) {
        return JoynrUtil.createDir(JoynrUtil.getBaseTempPath() + File.separator + dirName);
    }

    public static String getBaseTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTempDir() {
        Random rand = new Random();
        int randomInt = 1 + rand.nextInt();
        return JoynrUtil.createTempDir("tempDir" + randomInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                logger.debug("Creating target directory " + targetLocation + " failed.");
            }
            if ((children = sourceLocation.list()) == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                JoynrUtil.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceLocation);
                out = new FileOutputStream(targetLocation);
                JoynrUtil.copyStream(in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static Properties loadPropertyDirectory(File dir) throws IOException {
        Properties returnValue = new Properties();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("properties")) continue;
                FileInputStream inputStream = new FileInputStream(file);
                JoynrUtil.loadProperties(inputStream, Optional.of(returnValue));
            }
        }
        return returnValue;
    }

    public static Properties loadProperties(InputStream configInputStream) throws IOException {
        return JoynrUtil.loadProperties(configInputStream, Optional.empty());
    }

    public static Properties loadProperties(InputStream configInputStream, Optional<Properties> properties) throws IOException {
        Properties propertiesToReturn = new Properties();
        if (configInputStream != null) {
            if (!properties.isPresent()) {
                propertiesToReturn = new Properties();
            }
            propertiesToReturn.load(configInputStream);
            configInputStream.close();
            return propertiesToReturn;
        }
        return properties.get();
    }

    public static OS getOSFromString(String os) {
        if (os.equalsIgnoreCase("win32")) {
            return OS.WIN32;
        }
        if (os.equalsIgnoreCase("linux")) {
            return OS.LINUX;
        }
        if (os.equalsIgnoreCase("test")) {
            return OS.TEST;
        }
        return OS.UNDEFINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectoryFromJar(String jarName, String srcDir, File tmpDir) throws IOException {
        JarFile jf = null;
        ZipInputStream jarInputStream = null;
        try {
            jf = new JarFile(jarName);
            JarEntry je = jf.getJarEntry(srcDir);
            if (je.isDirectory()) {
                FileInputStream fis = new FileInputStream(jarName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                jarInputStream = new JarInputStream(bis);
                JarEntry ze = null;
                while ((ze = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    if (ze.isDirectory() || !ze.getName().contains(je.getName())) continue;
                    InputStream is = jf.getInputStream(ze);
                    String name = ze.getName().substring(ze.getName().lastIndexOf("/") + 1);
                    File tmpFile = new File(tmpDir + "/" + name);
                    tmpFile.deleteOnExit();
                    FileOutputStream outputStreamRuntime = new FileOutputStream(tmpFile);
                    JoynrUtil.copyStream(is, outputStreamRuntime);
                }
            }
        }
        finally {
            if (jf != null) {
                jf.close();
            }
            if (jarInputStream != null) {
                jarInputStream.close();
            }
        }
    }

    public static void checkConnectivity(String host) throws IOException {
        InetAddress headUnitAddr = InetAddress.getByName(host);
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (!headUnitAddr.isReachable(iface, 0, 5000)) continue;
            return;
        }
        throw new UnknownHostException("Connectivity check to the host \"" + host + "\" has failed");
    }

    public static String createUuidString() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return base64Encoder.encodeToString(uuidBytes.array());
    }

    public static enum OS {
        LINUX,
        WIN32,
        TEST,
        UNDEFINED;

    }
}

