/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final String BYTE = "Byte";
    private static final String SHORT = "Short";
    private static final String INTEGER = "Integer";
    private static final String LONG = "Long";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";

    public static List<Method> findMethodsByName(Class<?> clazz, String methodName) throws NoSuchMethodException {
        ArrayList<Method> methodsList = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        if (methodsList.isEmpty()) {
            throw new NoSuchMethodException(methodName);
        }
        Iterator<Method> iterator = methodsList.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (method.getName().equals(methodName)) continue;
            iterator.remove();
        }
        return methodsList;
    }

    public static Method findMethodByParamTypes(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !ReflectionUtils.checkParameterTypes(method, parameterTypes)) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    private static boolean checkParameterTypes(Method method, Class<?>[] parameterTypes) {
        Class<?>[] currentMethodParamTypes = method.getParameterTypes();
        if (currentMethodParamTypes.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (currentMethodParamTypes[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static Method findMethodByParamTypeNames(Class<?> clazz, String methodName, List<String> paramTypeNames) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !ReflectionUtils.checkParameterTypeNames(method, paramTypeNames)) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    private static boolean checkParameterTypeNames(Method method, List<String> paramTypeNames) {
        if (paramTypeNames == null) {
            String msg = "Received RPC without parameter types list! Method overloading might cause unexpected behaviour!";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        String[] currentMethodParamTypes = ReflectionUtils.toDatatypeNames(method.getParameterTypes());
        if (paramTypeNames.size() != currentMethodParamTypes.length) {
            return false;
        }
        for (int i = 0; i < currentMethodParamTypes.length; ++i) {
            String currentParamName = currentMethodParamTypes[i];
            String matchingParamName = paramTypeNames.get(i);
            if (currentParamName.equals(matchingParamName)) continue;
            return false;
        }
        return true;
    }

    public static List<List<Annotation>> findAndMergeParameterAnnotations(Method method) {
        ArrayList<List<Annotation>> res = new ArrayList<List<Annotation>>(method.getParameterTypes().length);
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            res.add(new LinkedList());
        }
        ReflectionUtils.findAndMergeAnnotations(method.getDeclaringClass(), method, res);
        return res;
    }

    private static void findAndMergeAnnotations(Class<?> clazz, Method method, List<List<Annotation>> res) {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method2 : methods) {
            if (!ReflectionUtils.areMethodNameAndParameterTypesEqual(method2, method)) continue;
            for (int i = 0; i < method2.getParameterAnnotations().length; ++i) {
                for (Annotation annotation : method2.getParameterAnnotations()[i]) {
                    res.get(i).add(annotation);
                }
            }
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            ReflectionUtils.findAndMergeAnnotations(genericDeclaration, method, res);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.findAndMergeAnnotations(clazz.getSuperclass(), method, res);
        }
    }

    private static boolean areMethodNameAndParameterTypesEqual(Method methodA, Method methodB) {
        Class<?>[] methodBParameterTypes;
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        Class<?>[] methodAParameterTypes = methodA.getParameterTypes();
        if (methodAParameterTypes.length != (methodBParameterTypes = methodB.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < methodAParameterTypes.length; ++i) {
            if (methodAParameterTypes[i].equals(methodBParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] toDatatypeNames(Class<?> ... types) {
        if (types == null) {
            return null;
        }
        String[] strings = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (type == null) continue;
            strings[i] = type.getCanonicalName().replace("java.lang.", "");
        }
        return strings;
    }

    public static Class<?>[] toJavaClasses(String ... typeNames) {
        if (typeNames == null) {
            return null;
        }
        Class[] classes = new Class[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            Class clazz;
            String[] nameTokens = typeNames[i].split("\\[");
            switch (nameTokens[0]) {
                case "Boolean": {
                    clazz = Boolean.class;
                    break;
                }
                case "Byte": {
                    clazz = Byte.class;
                    break;
                }
                case "Short": {
                    clazz = Short.class;
                    break;
                }
                case "Integer": {
                    clazz = Integer.class;
                    break;
                }
                case "Long": {
                    clazz = Long.class;
                    break;
                }
                case "Float": {
                    clazz = Float.class;
                    break;
                }
                case "Double": {
                    clazz = Double.class;
                    break;
                }
                case "String": {
                    clazz = String.class;
                    break;
                }
                default: {
                    try {
                        clazz = Class.forName(nameTokens[0]);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug("class not found", (Throwable)e);
                        clazz = Object.class;
                    }
                }
            }
            classes[i] = clazz = ReflectionUtils.processArrayTokens(clazz, nameTokens.length - 1);
        }
        return classes;
    }

    public static Method getStaticMethodFromSuperInterfaces(Class<?> clazz, String methodName) throws NoSuchMethodException {
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?>[] parentClasses = clazz.getInterfaces();
            if (parentClasses.length == 0) {
                throw e;
            }
            for (Class<?> parent : parentClasses) {
                try {
                    return ReflectionUtils.getStaticMethodFromSuperInterfaces(parent, methodName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            throw e;
        }
    }

    private static Class<?> processArrayTokens(Class<?> clazz, int i) {
        if (i == 0) {
            return clazz;
        }
        return ReflectionUtils.processArrayTokens(Array.newInstance(clazz, 0).getClass(), --i);
    }
}

