/*
 * Decompiled with CFR 0.152.
 */
package joynr.infrastructure.DacTypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.subtypes.JoynrType;
import java.io.Serializable;
import java.util.Arrays;
import joynr.infrastructure.DacTypes.MasterControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;

public class MasterAccessControlEntry
extends MasterControlEntry
implements Serializable,
JoynrType {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 0;
    @JsonProperty(value="operation")
    private String operation;
    @JsonProperty(value="defaultConsumerPermission")
    private Permission defaultConsumerPermission;
    @JsonProperty(value="possibleConsumerPermissions")
    private Permission[] possibleConsumerPermissions = new Permission[0];

    public MasterAccessControlEntry() {
        this.operation = "";
        this.defaultConsumerPermission = Permission.YES;
    }

    public MasterAccessControlEntry(MasterAccessControlEntry masterAccessControlEntryObj) {
        super(masterAccessControlEntryObj);
        this.operation = masterAccessControlEntryObj.operation;
        this.defaultConsumerPermission = masterAccessControlEntryObj.defaultConsumerPermission;
        this.possibleConsumerPermissions = masterAccessControlEntryObj.possibleConsumerPermissions;
    }

    public MasterAccessControlEntry(String uid, String domain, String interfaceName, TrustLevel defaultRequiredTrustLevel, TrustLevel[] possibleRequiredTrustLevels, TrustLevel defaultRequiredControlEntryChangeTrustLevel, TrustLevel[] possibleRequiredControlEntryChangeTrustLevels, String operation, Permission defaultConsumerPermission, Permission[] possibleConsumerPermissions) {
        super(uid, domain, interfaceName, defaultRequiredTrustLevel, possibleRequiredTrustLevels, defaultRequiredControlEntryChangeTrustLevel, possibleRequiredControlEntryChangeTrustLevels);
        this.operation = operation;
        this.defaultConsumerPermission = defaultConsumerPermission;
        if (possibleConsumerPermissions != null) {
            this.possibleConsumerPermissions = (Permission[])possibleConsumerPermissions.clone();
        }
    }

    @JsonIgnore
    public String getOperation() {
        return this.operation;
    }

    @JsonIgnore
    public void setOperation(String operation) {
        if (operation == null) {
            throw new IllegalArgumentException("setting operation to null is not allowed");
        }
        this.operation = operation;
    }

    @JsonIgnore
    public Permission getDefaultConsumerPermission() {
        return this.defaultConsumerPermission;
    }

    @JsonIgnore
    public void setDefaultConsumerPermission(Permission defaultConsumerPermission) {
        if (defaultConsumerPermission == null) {
            throw new IllegalArgumentException("setting defaultConsumerPermission to null is not allowed");
        }
        this.defaultConsumerPermission = defaultConsumerPermission;
    }

    @JsonIgnore
    public Permission[] getPossibleConsumerPermissions() {
        if (this.possibleConsumerPermissions != null) {
            return (Permission[])this.possibleConsumerPermissions.clone();
        }
        return null;
    }

    @JsonIgnore
    public void setPossibleConsumerPermissions(Permission[] possibleConsumerPermissions) {
        if (possibleConsumerPermissions == null) {
            throw new IllegalArgumentException("setting possibleConsumerPermissions to null is not allowed");
        }
        this.possibleConsumerPermissions = (Permission[])possibleConsumerPermissions.clone();
    }

    @Override
    public String toString() {
        return "MasterAccessControlEntry [" + super.toString() + ", operation=" + this.operation + ", defaultConsumerPermission=" + (Object)((Object)this.defaultConsumerPermission) + ", possibleConsumerPermissions=" + Arrays.toString((Object[])this.possibleConsumerPermissions) + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MasterAccessControlEntry other = (MasterAccessControlEntry)obj;
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.defaultConsumerPermission == null ? other.defaultConsumerPermission != null : !this.defaultConsumerPermission.equals((Object)other.defaultConsumerPermission)) {
            return false;
        }
        return !(this.possibleConsumerPermissions == null ? other.possibleConsumerPermissions != null : !Arrays.deepEquals((Object[])this.possibleConsumerPermissions, (Object[])other.possibleConsumerPermissions));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.defaultConsumerPermission == null ? 0 : this.defaultConsumerPermission.hashCode());
        result = 31 * result + (this.possibleConsumerPermissions == null ? 0 : Arrays.hashCode((Object[])this.possibleConsumerPermissions));
        return result;
    }
}

