/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import io.joynr.pubsub.SubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicastSubscriptionQos
extends SubscriptionQos {
    private static final Logger logger = LoggerFactory.getLogger(UnicastSubscriptionQos.class);
    private static final long serialVersionUID = 1L;
    protected static final long MIN_PUBLICATION_TTL_MS = 100L;
    protected static final long MAX_PUBLICATION_TTL_MS = 2592000000L;
    protected static final long DEFAULT_PUBLICATION_TTL_MS = 10000L;
    private long publicationTtlMs = 10000L;

    @Override
    public UnicastSubscriptionQos setExpiryDateMs(long expiryDateMs) {
        return (UnicastSubscriptionQos)super.setExpiryDateMs(expiryDateMs);
    }

    @Override
    public UnicastSubscriptionQos setValidityMs(long validityMs) {
        return (UnicastSubscriptionQos)super.setValidityMs(validityMs);
    }

    public long getPublicationTtlMs() {
        return this.publicationTtlMs;
    }

    public SubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        if (publicationTtlMs < 100L) {
            this.publicationTtlMs = 100L;
            logger.warn("PublicationTtlMs < MIN_PUBLICATION_TTL. Using MIN_PUBLICATION_TTL: {}", (Object)100L);
        } else if (publicationTtlMs > 2592000000L) {
            this.publicationTtlMs = 2592000000L;
            logger.warn("PublicationTtlMs > MAX_PUBLICATION_TTL. Using MAX_PUBLICATION_TTL: {}", (Object)2592000000L);
        } else {
            this.publicationTtlMs = publicationTtlMs;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.publicationTtlMs ^ this.publicationTtlMs >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnicastSubscriptionQos other = (UnicastSubscriptionQos)obj;
        return this.publicationTtlMs == other.publicationTtlMs;
    }
}

