/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.exceptions.JoynrException;
import io.joynr.provider.DeferredListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import joynr.exceptions.ProviderRuntimeException;

public abstract class AbstractDeferred {
    private State state = State.PENDING;
    private JoynrException error = null;
    private Object[] values = null;
    private List<DeferredListener> listeners = new ArrayList<DeferredListener>();

    protected synchronized boolean resolve(Object ... values) {
        if (this.isSettled()) {
            return false;
        }
        this.values = values;
        this.state = State.FULFILLED;
        this.notifyListeners();
        return true;
    }

    protected synchronized boolean reject(JoynrException error) {
        if (this.isSettled()) {
            return false;
        }
        this.state = State.REJECTED;
        this.error = error;
        this.notifyListeners();
        return true;
    }

    public synchronized boolean reject(ProviderRuntimeException error) {
        return this.reject((JoynrException)error);
    }

    public Optional<JoynrException> getError() {
        return Optional.ofNullable(this.error);
    }

    public Optional<Object[]> getValues() {
        return Optional.ofNullable(this.values);
    }

    private void notifyListeners() {
        for (DeferredListener listener : this.listeners) {
            listener.onSettlement();
        }
    }

    public synchronized void addListener(DeferredListener listener) {
        this.listeners.add(listener);
        if (this.isSettled()) {
            listener.onSettlement();
        }
    }

    public boolean isFulfilled() {
        return this.state == State.FULFILLED;
    }

    public boolean isRejected() {
        return this.state == State.REJECTED;
    }

    public boolean isSettled() {
        return this.state == State.FULFILLED || this.state == State.REJECTED;
    }

    private static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

