		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.MasterControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Master Access Control Entry (Master ACE) stores default consumer permissions of users for a domain/interface/operations combination. Additionally, it contains possible consumer permissions to be used to override default consumer permissions in Owner Access Control Entries (Owner ACEs). Master ACEs are stored by the Master Access Control List (Master ACL) and the optional Mediator Access Control List (Mediator ACL).
 */
@SuppressWarnings("serial")
public class MasterAccessControlEntry extends MasterControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("operation")
	private String operation;
	@JsonProperty("defaultConsumerPermission")
	private Permission defaultConsumerPermission;
	@JsonProperty("possibleConsumerPermissions")
	private Permission[] possibleConsumerPermissions = {};

	/**
	 * Default Constructor
	 */
	public MasterAccessControlEntry() {
		this.operation = "";
		this.defaultConsumerPermission = Permission.YES;
	}

	/**
	 * Copy constructor
	 *
	 * @param masterAccessControlEntryObj reference to the object to be copied
	 */
	public MasterAccessControlEntry(MasterAccessControlEntry masterAccessControlEntryObj) {
		super(masterAccessControlEntryObj);
		this.operation = masterAccessControlEntryObj.operation;
		this.defaultConsumerPermission = masterAccessControlEntryObj.defaultConsumerPermission;
		this.possibleConsumerPermissions = masterAccessControlEntryObj.possibleConsumerPermissions;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param defaultRequiredTrustLevel The default required trusted level (TL). TL depends on used device and Authentication mechanism.
	 * @param possibleRequiredTrustLevels A list of all possible Trust Levels that may be used in an owner CE to overwrite the default required TL.
	 * @param defaultRequiredControlEntryChangeTrustLevel The default Trust Level (TL) that is needed by the requester in order to create, edit or delete a corresponding owner CE.
	 * @param possibleRequiredControlEntryChangeTrustLevels A list of all possible Trust Levels (TLs) that may be used in an owner CE to override the default required CE change TL.
	 * @param operation The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param defaultConsumerPermission The default consumer permission that applies to the specified domain, interface and operations combination if there does not exist a corresponding ACE in the owner Access Control List (ACL).
	 * @param possibleConsumerPermissions A list of all possible consumer permissions that may be used in an owner ACE to overwrite the default consumer permission.
	 */
	public MasterAccessControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel defaultRequiredTrustLevel,
		TrustLevel[] possibleRequiredTrustLevels,
		TrustLevel defaultRequiredControlEntryChangeTrustLevel,
		TrustLevel[] possibleRequiredControlEntryChangeTrustLevels,
		String operation,
		Permission defaultConsumerPermission,
		Permission[] possibleConsumerPermissions
		) {
		super(
				uid,
				domain,
				interfaceName,
				defaultRequiredTrustLevel,
				possibleRequiredTrustLevels,
				defaultRequiredControlEntryChangeTrustLevel,
				possibleRequiredControlEntryChangeTrustLevels
		);
		this.operation = operation;
		this.defaultConsumerPermission = defaultConsumerPermission;
		if(possibleConsumerPermissions != null) {
			this.possibleConsumerPermissions = possibleConsumerPermissions.clone();
		}
	}

	/**
	 * Gets Operation
	 *
	 * @return The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public String getOperation() {
		return operation;
	}

	/**
	 * Sets Operation
	 *
	 * @param operation The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public void setOperation(String operation) {
		if (operation == null) {
			throw new IllegalArgumentException("setting operation to null is not allowed");
		}
		this.operation = operation;
	}

	/**
	 * Gets DefaultConsumerPermission
	 *
	 * @return The default consumer permission that applies to the specified domain, interface and operations combination if there does not exist a corresponding ACE in the owner Access Control List (ACL).
	 */
	@JsonIgnore
	public Permission getDefaultConsumerPermission() {
		return defaultConsumerPermission;
	}

	/**
	 * Sets DefaultConsumerPermission
	 *
	 * @param defaultConsumerPermission The default consumer permission that applies to the specified domain, interface and operations combination if there does not exist a corresponding ACE in the owner Access Control List (ACL).
	 */
	@JsonIgnore
	public void setDefaultConsumerPermission(Permission defaultConsumerPermission) {
		if (defaultConsumerPermission == null) {
			throw new IllegalArgumentException("setting defaultConsumerPermission to null is not allowed");
		}
		this.defaultConsumerPermission = defaultConsumerPermission;
	}

	/**
	 * Gets PossibleConsumerPermissions
	 *
	 * @return A list of all possible consumer permissions that may be used in an owner ACE to overwrite the default consumer permission.
	 */
	@JsonIgnore
	public Permission[] getPossibleConsumerPermissions() {
		if(possibleConsumerPermissions != null) {
			return possibleConsumerPermissions.clone();
		} else {
			return null;
		}
	}

	/**
	 * Sets PossibleConsumerPermissions
	 *
	 * @param possibleConsumerPermissions A list of all possible consumer permissions that may be used in an owner ACE to overwrite the default consumer permission.
	 */
	@JsonIgnore
	public void setPossibleConsumerPermissions(Permission[] possibleConsumerPermissions) {
		if (possibleConsumerPermissions == null) {
			throw new IllegalArgumentException("setting possibleConsumerPermissions to null is not allowed");
		}
		this.possibleConsumerPermissions = possibleConsumerPermissions.clone();
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "MasterAccessControlEntry ["
		+ super.toString() + ", "
		+ "operation=" + this.operation + ", "
		+ "defaultConsumerPermission=" + this.defaultConsumerPermission + ", "
		+ "possibleConsumerPermissions=" + java.util.Arrays.toString(this.possibleConsumerPermissions)
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		MasterAccessControlEntry other = (MasterAccessControlEntry) obj;
		if (this.operation == null) {
			if (other.operation != null) {
				return false;
			}
		} else if (!this.operation.equals(other.operation)){
			return false;
		}
		if (this.defaultConsumerPermission == null) {
			if (other.defaultConsumerPermission != null) {
				return false;
			}
		} else if (!this.defaultConsumerPermission.equals(other.defaultConsumerPermission)){
			return false;
		}
		if (this.possibleConsumerPermissions == null) {
			if (other.possibleConsumerPermissions != null) {
				return false;
			}
		} else if (!java.util.Arrays.deepEquals(this.possibleConsumerPermissions, other.possibleConsumerPermissions)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.operation == null) ? 0 : this.operation.hashCode());
		result = prime * result + ((this.defaultConsumerPermission == null) ? 0 : this.defaultConsumerPermission.hashCode());
		result = prime * result + ((this.possibleConsumerPermissions == null) ? 0 : java.util.Arrays.hashCode(this.possibleConsumerPermissions));
		return result;
	}
}

	
