		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.ControlEntry;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Master Control Entry (Master CE) stores default Trust Levels (TLs) of users that must be met to apply this CE or to change this CE. Additionally, it contains possible TLs to be used to override default TLs in Owner Control Entries (Owner CEs). It is the base class for <code>MasterAccessControlEntry</code> and <code>MasterRegistrationControlEntry</code>.
 */
@SuppressWarnings("serial")
public class MasterControlEntry extends ControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("defaultRequiredTrustLevel")
	private TrustLevel defaultRequiredTrustLevel;
	@JsonProperty("possibleRequiredTrustLevels")
	private TrustLevel[] possibleRequiredTrustLevels = {};
	@JsonProperty("defaultRequiredControlEntryChangeTrustLevel")
	private TrustLevel defaultRequiredControlEntryChangeTrustLevel;
	@JsonProperty("possibleRequiredControlEntryChangeTrustLevels")
	private TrustLevel[] possibleRequiredControlEntryChangeTrustLevels = {};

	/**
	 * Default Constructor
	 */
	public MasterControlEntry() {
		this.defaultRequiredTrustLevel = TrustLevel.HIGH;
		this.defaultRequiredControlEntryChangeTrustLevel = TrustLevel.HIGH;
	}

	/**
	 * Copy constructor
	 *
	 * @param masterControlEntryObj reference to the object to be copied
	 */
	public MasterControlEntry(MasterControlEntry masterControlEntryObj) {
		super(masterControlEntryObj);
		this.defaultRequiredTrustLevel = masterControlEntryObj.defaultRequiredTrustLevel;
		this.possibleRequiredTrustLevels = masterControlEntryObj.possibleRequiredTrustLevels;
		this.defaultRequiredControlEntryChangeTrustLevel = masterControlEntryObj.defaultRequiredControlEntryChangeTrustLevel;
		this.possibleRequiredControlEntryChangeTrustLevels = masterControlEntryObj.possibleRequiredControlEntryChangeTrustLevels;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param defaultRequiredTrustLevel The default required trusted level (TL). TL depends on used device and Authentication mechanism.
	 * @param possibleRequiredTrustLevels A list of all possible Trust Levels that may be used in an owner CE to overwrite the default required TL.
	 * @param defaultRequiredControlEntryChangeTrustLevel The default Trust Level (TL) that is needed by the requester in order to create, edit or delete a corresponding owner CE.
	 * @param possibleRequiredControlEntryChangeTrustLevels A list of all possible Trust Levels (TLs) that may be used in an owner CE to override the default required CE change TL.
	 */
	public MasterControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel defaultRequiredTrustLevel,
		TrustLevel[] possibleRequiredTrustLevels,
		TrustLevel defaultRequiredControlEntryChangeTrustLevel,
		TrustLevel[] possibleRequiredControlEntryChangeTrustLevels
		) {
		super(
				uid,
				domain,
				interfaceName
		);
		this.defaultRequiredTrustLevel = defaultRequiredTrustLevel;
		if(possibleRequiredTrustLevels != null) {
			this.possibleRequiredTrustLevels = possibleRequiredTrustLevels.clone();
		}
		this.defaultRequiredControlEntryChangeTrustLevel = defaultRequiredControlEntryChangeTrustLevel;
		if(possibleRequiredControlEntryChangeTrustLevels != null) {
			this.possibleRequiredControlEntryChangeTrustLevels = possibleRequiredControlEntryChangeTrustLevels.clone();
		}
	}

	/**
	 * Gets DefaultRequiredTrustLevel
	 *
	 * @return The default required trusted level (TL). TL depends on used device and Authentication mechanism.
	 */
	@JsonIgnore
	public TrustLevel getDefaultRequiredTrustLevel() {
		return defaultRequiredTrustLevel;
	}

	/**
	 * Sets DefaultRequiredTrustLevel
	 *
	 * @param defaultRequiredTrustLevel The default required trusted level (TL). TL depends on used device and Authentication mechanism.
	 */
	@JsonIgnore
	public void setDefaultRequiredTrustLevel(TrustLevel defaultRequiredTrustLevel) {
		if (defaultRequiredTrustLevel == null) {
			throw new IllegalArgumentException("setting defaultRequiredTrustLevel to null is not allowed");
		}
		this.defaultRequiredTrustLevel = defaultRequiredTrustLevel;
	}

	/**
	 * Gets PossibleRequiredTrustLevels
	 *
	 * @return A list of all possible Trust Levels that may be used in an owner CE to overwrite the default required TL.
	 */
	@JsonIgnore
	public TrustLevel[] getPossibleRequiredTrustLevels() {
		if(possibleRequiredTrustLevels != null) {
			return possibleRequiredTrustLevels.clone();
		} else {
			return null;
		}
	}

	/**
	 * Sets PossibleRequiredTrustLevels
	 *
	 * @param possibleRequiredTrustLevels A list of all possible Trust Levels that may be used in an owner CE to overwrite the default required TL.
	 */
	@JsonIgnore
	public void setPossibleRequiredTrustLevels(TrustLevel[] possibleRequiredTrustLevels) {
		if (possibleRequiredTrustLevels == null) {
			throw new IllegalArgumentException("setting possibleRequiredTrustLevels to null is not allowed");
		}
		this.possibleRequiredTrustLevels = possibleRequiredTrustLevels.clone();
	}

	/**
	 * Gets DefaultRequiredControlEntryChangeTrustLevel
	 *
	 * @return The default Trust Level (TL) that is needed by the requester in order to create, edit or delete a corresponding owner CE.
	 */
	@JsonIgnore
	public TrustLevel getDefaultRequiredControlEntryChangeTrustLevel() {
		return defaultRequiredControlEntryChangeTrustLevel;
	}

	/**
	 * Sets DefaultRequiredControlEntryChangeTrustLevel
	 *
	 * @param defaultRequiredControlEntryChangeTrustLevel The default Trust Level (TL) that is needed by the requester in order to create, edit or delete a corresponding owner CE.
	 */
	@JsonIgnore
	public void setDefaultRequiredControlEntryChangeTrustLevel(TrustLevel defaultRequiredControlEntryChangeTrustLevel) {
		if (defaultRequiredControlEntryChangeTrustLevel == null) {
			throw new IllegalArgumentException("setting defaultRequiredControlEntryChangeTrustLevel to null is not allowed");
		}
		this.defaultRequiredControlEntryChangeTrustLevel = defaultRequiredControlEntryChangeTrustLevel;
	}

	/**
	 * Gets PossibleRequiredControlEntryChangeTrustLevels
	 *
	 * @return A list of all possible Trust Levels (TLs) that may be used in an owner CE to override the default required CE change TL.
	 */
	@JsonIgnore
	public TrustLevel[] getPossibleRequiredControlEntryChangeTrustLevels() {
		if(possibleRequiredControlEntryChangeTrustLevels != null) {
			return possibleRequiredControlEntryChangeTrustLevels.clone();
		} else {
			return null;
		}
	}

	/**
	 * Sets PossibleRequiredControlEntryChangeTrustLevels
	 *
	 * @param possibleRequiredControlEntryChangeTrustLevels A list of all possible Trust Levels (TLs) that may be used in an owner CE to override the default required CE change TL.
	 */
	@JsonIgnore
	public void setPossibleRequiredControlEntryChangeTrustLevels(TrustLevel[] possibleRequiredControlEntryChangeTrustLevels) {
		if (possibleRequiredControlEntryChangeTrustLevels == null) {
			throw new IllegalArgumentException("setting possibleRequiredControlEntryChangeTrustLevels to null is not allowed");
		}
		this.possibleRequiredControlEntryChangeTrustLevels = possibleRequiredControlEntryChangeTrustLevels.clone();
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "MasterControlEntry ["
		+ super.toString() + ", "
		+ "defaultRequiredTrustLevel=" + this.defaultRequiredTrustLevel + ", "
		+ "possibleRequiredTrustLevels=" + java.util.Arrays.toString(this.possibleRequiredTrustLevels) + ", "
		+ "defaultRequiredControlEntryChangeTrustLevel=" + this.defaultRequiredControlEntryChangeTrustLevel + ", "
		+ "possibleRequiredControlEntryChangeTrustLevels=" + java.util.Arrays.toString(this.possibleRequiredControlEntryChangeTrustLevels)
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		MasterControlEntry other = (MasterControlEntry) obj;
		if (this.defaultRequiredTrustLevel == null) {
			if (other.defaultRequiredTrustLevel != null) {
				return false;
			}
		} else if (!this.defaultRequiredTrustLevel.equals(other.defaultRequiredTrustLevel)){
			return false;
		}
		if (this.possibleRequiredTrustLevels == null) {
			if (other.possibleRequiredTrustLevels != null) {
				return false;
			}
		} else if (!java.util.Arrays.deepEquals(this.possibleRequiredTrustLevels, other.possibleRequiredTrustLevels)){
			return false;
		}
		if (this.defaultRequiredControlEntryChangeTrustLevel == null) {
			if (other.defaultRequiredControlEntryChangeTrustLevel != null) {
				return false;
			}
		} else if (!this.defaultRequiredControlEntryChangeTrustLevel.equals(other.defaultRequiredControlEntryChangeTrustLevel)){
			return false;
		}
		if (this.possibleRequiredControlEntryChangeTrustLevels == null) {
			if (other.possibleRequiredControlEntryChangeTrustLevels != null) {
				return false;
			}
		} else if (!java.util.Arrays.deepEquals(this.possibleRequiredControlEntryChangeTrustLevels, other.possibleRequiredControlEntryChangeTrustLevels)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.defaultRequiredTrustLevel == null) ? 0 : this.defaultRequiredTrustLevel.hashCode());
		result = prime * result + ((this.possibleRequiredTrustLevels == null) ? 0 : java.util.Arrays.hashCode(this.possibleRequiredTrustLevels));
		result = prime * result + ((this.defaultRequiredControlEntryChangeTrustLevel == null) ? 0 : this.defaultRequiredControlEntryChangeTrustLevel.hashCode());
		result = prime * result + ((this.possibleRequiredControlEntryChangeTrustLevels == null) ? 0 : java.util.Arrays.hashCode(this.possibleRequiredControlEntryChangeTrustLevels));
		return result;
	}
}

	
