		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.MasterControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Master Registration Control Entry (Master RCE) stores default provider permissions of users for a domain/interface combination. Additionally, it contains possible provider permissions to be used to override default provider permissions in Owner Registration Control Entries (Owner RCEs). Master RCEs are stored by the Master Registration Control List (Master RCL) and the optional Mediator Registration Control List (Mediator RCL).
 */
@SuppressWarnings("serial")
public class MasterRegistrationControlEntry extends MasterControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("defaultProviderPermission")
	private Permission defaultProviderPermission;
	@JsonProperty("possibleProviderPermissions")
	private Permission[] possibleProviderPermissions = {};

	/**
	 * Default Constructor
	 */
	public MasterRegistrationControlEntry() {
		this.defaultProviderPermission = Permission.YES;
	}

	/**
	 * Copy constructor
	 *
	 * @param masterRegistrationControlEntryObj reference to the object to be copied
	 */
	public MasterRegistrationControlEntry(MasterRegistrationControlEntry masterRegistrationControlEntryObj) {
		super(masterRegistrationControlEntryObj);
		this.defaultProviderPermission = masterRegistrationControlEntryObj.defaultProviderPermission;
		this.possibleProviderPermissions = masterRegistrationControlEntryObj.possibleProviderPermissions;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param defaultRequiredTrustLevel The default required trusted level (TL). TL depends on used device and Authentication mechanism.
	 * @param possibleRequiredTrustLevels A list of all possible Trust Levels that may be used in an owner CE to overwrite the default required TL.
	 * @param defaultRequiredControlEntryChangeTrustLevel The default Trust Level (TL) that is needed by the requester in order to create, edit or delete a corresponding owner CE.
	 * @param possibleRequiredControlEntryChangeTrustLevels A list of all possible Trust Levels (TLs) that may be used in an owner CE to override the default required CE change TL.
	 * @param defaultProviderPermission The default provider permission that applies to the specified domain and interface combination if there does not exist a corresponding RCE in the Owner Registration Control List (Owner RCL).
	 * @param possibleProviderPermissions A list of all possible provider permissions that may be used in an owner RCE to overwrite the default provider permission.
	 */
	public MasterRegistrationControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel defaultRequiredTrustLevel,
		TrustLevel[] possibleRequiredTrustLevels,
		TrustLevel defaultRequiredControlEntryChangeTrustLevel,
		TrustLevel[] possibleRequiredControlEntryChangeTrustLevels,
		Permission defaultProviderPermission,
		Permission[] possibleProviderPermissions
		) {
		super(
				uid,
				domain,
				interfaceName,
				defaultRequiredTrustLevel,
				possibleRequiredTrustLevels,
				defaultRequiredControlEntryChangeTrustLevel,
				possibleRequiredControlEntryChangeTrustLevels
		);
		this.defaultProviderPermission = defaultProviderPermission;
		if(possibleProviderPermissions != null) {
			this.possibleProviderPermissions = possibleProviderPermissions.clone();
		}
	}

	/**
	 * Gets DefaultProviderPermission
	 *
	 * @return The default provider permission that applies to the specified domain and interface combination if there does not exist a corresponding RCE in the Owner Registration Control List (Owner RCL).
	 */
	@JsonIgnore
	public Permission getDefaultProviderPermission() {
		return defaultProviderPermission;
	}

	/**
	 * Sets DefaultProviderPermission
	 *
	 * @param defaultProviderPermission The default provider permission that applies to the specified domain and interface combination if there does not exist a corresponding RCE in the Owner Registration Control List (Owner RCL).
	 */
	@JsonIgnore
	public void setDefaultProviderPermission(Permission defaultProviderPermission) {
		if (defaultProviderPermission == null) {
			throw new IllegalArgumentException("setting defaultProviderPermission to null is not allowed");
		}
		this.defaultProviderPermission = defaultProviderPermission;
	}

	/**
	 * Gets PossibleProviderPermissions
	 *
	 * @return A list of all possible provider permissions that may be used in an owner RCE to overwrite the default provider permission.
	 */
	@JsonIgnore
	public Permission[] getPossibleProviderPermissions() {
		if(possibleProviderPermissions != null) {
			return possibleProviderPermissions.clone();
		} else {
			return null;
		}
	}

	/**
	 * Sets PossibleProviderPermissions
	 *
	 * @param possibleProviderPermissions A list of all possible provider permissions that may be used in an owner RCE to overwrite the default provider permission.
	 */
	@JsonIgnore
	public void setPossibleProviderPermissions(Permission[] possibleProviderPermissions) {
		if (possibleProviderPermissions == null) {
			throw new IllegalArgumentException("setting possibleProviderPermissions to null is not allowed");
		}
		this.possibleProviderPermissions = possibleProviderPermissions.clone();
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "MasterRegistrationControlEntry ["
		+ super.toString() + ", "
		+ "defaultProviderPermission=" + this.defaultProviderPermission + ", "
		+ "possibleProviderPermissions=" + java.util.Arrays.toString(this.possibleProviderPermissions)
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		MasterRegistrationControlEntry other = (MasterRegistrationControlEntry) obj;
		if (this.defaultProviderPermission == null) {
			if (other.defaultProviderPermission != null) {
				return false;
			}
		} else if (!this.defaultProviderPermission.equals(other.defaultProviderPermission)){
			return false;
		}
		if (this.possibleProviderPermissions == null) {
			if (other.possibleProviderPermissions != null) {
				return false;
			}
		} else if (!java.util.Arrays.deepEquals(this.possibleProviderPermissions, other.possibleProviderPermissions)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.defaultProviderPermission == null) ? 0 : this.defaultProviderPermission.hashCode());
		result = prime * result + ((this.possibleProviderPermissions == null) ? 0 : java.util.Arrays.hashCode(this.possibleProviderPermissions));
		return result;
	}
}

	
