		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.ControlEntry;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Owner Control Entry (Owner CE) stores Trust Levels (TLs) of users that must be met to apply this CE or to change this CE. It is the base class for <code>OwnerAccessControlEntry</code> and <code>OwnerRegistrationControlEntry</code>.
 */
@SuppressWarnings("serial")
public class OwnerControlEntry extends ControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("requiredTrustLevel")
	private TrustLevel requiredTrustLevel;
	@JsonProperty("requiredAceChangeTrustLevel")
	private TrustLevel requiredAceChangeTrustLevel;

	/**
	 * Default Constructor
	 */
	public OwnerControlEntry() {
		this.requiredTrustLevel = TrustLevel.HIGH;
		this.requiredAceChangeTrustLevel = TrustLevel.HIGH;
	}

	/**
	 * Copy constructor
	 *
	 * @param ownerControlEntryObj reference to the object to be copied
	 */
	public OwnerControlEntry(OwnerControlEntry ownerControlEntryObj) {
		super(ownerControlEntryObj);
		this.requiredTrustLevel = ownerControlEntryObj.requiredTrustLevel;
		this.requiredAceChangeTrustLevel = ownerControlEntryObj.requiredAceChangeTrustLevel;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param requiredTrustLevel The Trust Level (TL) that is needed by the requester in order to get the permission defined in this CE. The TL must be listed in the possible required TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 * @param requiredAceChangeTrustLevel The Trust Level (TL) that is needed by the requester in order to create, edit or delete an Owner ACE. The TL must be listed in the possible required CE Change TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 */
	public OwnerControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel requiredTrustLevel,
		TrustLevel requiredAceChangeTrustLevel
		) {
		super(
				uid,
				domain,
				interfaceName
		);
		this.requiredTrustLevel = requiredTrustLevel;
		this.requiredAceChangeTrustLevel = requiredAceChangeTrustLevel;
	}

	/**
	 * Gets RequiredTrustLevel
	 *
	 * @return The Trust Level (TL) that is needed by the requester in order to get the permission defined in this CE. The TL must be listed in the possible required TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public TrustLevel getRequiredTrustLevel() {
		return requiredTrustLevel;
	}

	/**
	 * Sets RequiredTrustLevel
	 *
	 * @param requiredTrustLevel The Trust Level (TL) that is needed by the requester in order to get the permission defined in this CE. The TL must be listed in the possible required TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public void setRequiredTrustLevel(TrustLevel requiredTrustLevel) {
		if (requiredTrustLevel == null) {
			throw new IllegalArgumentException("setting requiredTrustLevel to null is not allowed");
		}
		this.requiredTrustLevel = requiredTrustLevel;
	}

	/**
	 * Gets RequiredAceChangeTrustLevel
	 *
	 * @return The Trust Level (TL) that is needed by the requester in order to create, edit or delete an Owner ACE. The TL must be listed in the possible required CE Change TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public TrustLevel getRequiredAceChangeTrustLevel() {
		return requiredAceChangeTrustLevel;
	}

	/**
	 * Sets RequiredAceChangeTrustLevel
	 *
	 * @param requiredAceChangeTrustLevel The Trust Level (TL) that is needed by the requester in order to create, edit or delete an Owner ACE. The TL must be listed in the possible required CE Change TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public void setRequiredAceChangeTrustLevel(TrustLevel requiredAceChangeTrustLevel) {
		if (requiredAceChangeTrustLevel == null) {
			throw new IllegalArgumentException("setting requiredAceChangeTrustLevel to null is not allowed");
		}
		this.requiredAceChangeTrustLevel = requiredAceChangeTrustLevel;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "OwnerControlEntry ["
		+ super.toString() + ", "
		+ "requiredTrustLevel=" + this.requiredTrustLevel + ", "
		+ "requiredAceChangeTrustLevel=" + this.requiredAceChangeTrustLevel
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		OwnerControlEntry other = (OwnerControlEntry) obj;
		if (this.requiredTrustLevel == null) {
			if (other.requiredTrustLevel != null) {
				return false;
			}
		} else if (!this.requiredTrustLevel.equals(other.requiredTrustLevel)){
			return false;
		}
		if (this.requiredAceChangeTrustLevel == null) {
			if (other.requiredAceChangeTrustLevel != null) {
				return false;
			}
		} else if (!this.requiredAceChangeTrustLevel.equals(other.requiredAceChangeTrustLevel)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.requiredTrustLevel == null) ? 0 : this.requiredTrustLevel.hashCode());
		result = prime * result + ((this.requiredAceChangeTrustLevel == null) ? 0 : this.requiredAceChangeTrustLevel.hashCode());
		return result;
	}
}

	
