/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.infrastructure;

import io.joynr.provider.Promise;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import joynr.exceptions.ApplicationException;

import io.joynr.provider.JoynrInterface;
import io.joynr.JoynrVersion;

import joynr.types.ChangeType;
import joynr.types.GlobalDiscoveryEntry;

import io.joynr.provider.SubscriptionPublisherInjection;

interface GlobalCapabilitiesDirectorySubscriptionPublisherInjection extends SubscriptionPublisherInjection<GlobalCapabilitiesDirectorySubscriptionPublisher> {}

@JoynrInterface(provides = GlobalCapabilitiesDirectory.class, provider = GlobalCapabilitiesDirectoryProvider.class, name = "infrastructure/GlobalCapabilitiesDirectory")
@JoynrVersion(major = 0, minor = 3)
public interface GlobalCapabilitiesDirectoryProvider extends GlobalCapabilitiesDirectorySubscriptionPublisherInjection {


	/**
	 * add
	 * @param globalDiscoveryEntries the parameter globalDiscoveryEntries
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> add(
			GlobalDiscoveryEntry[] globalDiscoveryEntries
	);

	/**
	 * add
	 * @param globalDiscoveryEntry the parameter globalDiscoveryEntry
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> add(
			GlobalDiscoveryEntry globalDiscoveryEntry
	);

	/**
	 * add
	 * @param globalDiscoveryEntry the parameter globalDiscoveryEntry
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Add1Deferred> add(
			GlobalDiscoveryEntry globalDiscoveryEntry,
			String[] gbids
	);

	/**
	 * lookup
	 * @param domains the parameter domains
	 * @param interfaceName the parameter interfaceName
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup1Deferred> lookup(
			String[] domains,
			String interfaceName
	);

	/**
	 * lookup
	 * @param domains the parameter domains
	 * @param interfaceName the parameter interfaceName
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup2Deferred> lookup(
			String[] domains,
			String interfaceName,
			String[] gbids
	);

	/**
	 * lookup
	 * @param participantId the parameter participantId
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup3Deferred> lookup(
			String participantId
	);

	/**
	 * lookup
	 * @param participantId the parameter participantId
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup4Deferred> lookup(
			String participantId,
			String[] gbids
	);

	/**
	 * remove
	 * @param participantIds the parameter participantIds
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> remove(
			String[] participantIds
	);

	/**
	 * remove
	 * @param participantId the parameter participantId
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> remove(
			String participantId
	);

	/**
	 * remove
	 * @param participantId the parameter participantId
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Remove1Deferred> remove(
			String participantId,
			String[] gbids
	);

	/**
	 * removeStale
	 * @param clusterControllerId the parameter clusterControllerId
	 * @param maxLastSeenDateMs the parameter maxLastSeenDateMs
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> removeStale(
			String clusterControllerId,
			Long maxLastSeenDateMs
	);

	/**
	 * touch
	 * @param clusterControllerId the parameter clusterControllerId
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> touch(
			String clusterControllerId
	);

	/**
	 * touch
	 * @param clusterControllerId the parameter clusterControllerId
	 * @param participantIds the parameter participantIds
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> touch(
			String clusterControllerId,
			String[] participantIds
	);

	public class Add1Deferred extends AbstractDeferred {
		public synchronized boolean resolve() {
			Object[] values = new Object[] {};
			return super.resolve(values);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class Lookup1Deferred extends AbstractDeferred {
		public synchronized boolean resolve(GlobalDiscoveryEntry[] result) {
			return super.resolve((Object)result);
		}
	}

	public class Lookup2Deferred extends AbstractDeferred {
		public synchronized boolean resolve(GlobalDiscoveryEntry[] result) {
			return super.resolve((Object)result);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class Lookup3Deferred extends AbstractDeferred {
		public synchronized boolean resolve(GlobalDiscoveryEntry result) {
			return super.resolve(result);
		}
	}

	public class Lookup4Deferred extends AbstractDeferred {
		public synchronized boolean resolve(GlobalDiscoveryEntry result) {
			return super.resolve(result);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class Remove1Deferred extends AbstractDeferred {
		public synchronized boolean resolve() {
			Object[] values = new Object[] {};
			return super.resolve(values);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}
}
