/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.system;

import io.joynr.provider.Promise;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import joynr.exceptions.ApplicationException;

import io.joynr.provider.JoynrInterface;
import io.joynr.JoynrVersion;

import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.DiscoveryQos;

@JoynrInterface(provides = Discovery.class, provider = DiscoveryProvider.class, name = "system/Discovery")
@JoynrVersion(major = 0, minor = 3)
public interface DiscoveryProvider {


	/**
	 * add
	 * @param discoveryEntry the parameter discoveryEntry
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> add(
			DiscoveryEntry discoveryEntry
	);

	/**
	 * add
	 * @param discoveryEntry the parameter discoveryEntry
	 * @param awaitGlobalRegistration the parameter awaitGlobalRegistration
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> add(
			DiscoveryEntry discoveryEntry,
			Boolean awaitGlobalRegistration
	);

	/**
	 * add
	 * @param discoveryEntry the parameter discoveryEntry
	 * @param awaitGlobalRegistration the parameter awaitGlobalRegistration
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Add1Deferred> add(
			DiscoveryEntry discoveryEntry,
			Boolean awaitGlobalRegistration,
			String[] gbids
	);

	/**
	 * addToAll
	 * @param discoveryEntry the parameter discoveryEntry
	 * @param awaitGlobalRegistration the parameter awaitGlobalRegistration
	 * @return promise for asynchronous handling
	 */
	public Promise<AddToAllDeferred> addToAll(
			DiscoveryEntry discoveryEntry,
			Boolean awaitGlobalRegistration
	);

	/**
	 * lookup
	 * @param domains the parameter domains
	 * @param interfaceName the parameter interfaceName
	 * @param discoveryQos the parameter discoveryQos
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup1Deferred> lookup(
			String[] domains,
			String interfaceName,
			DiscoveryQos discoveryQos
	);

	/**
	 * lookup
	 * @param domains the parameter domains
	 * @param interfaceName the parameter interfaceName
	 * @param discoveryQos the parameter discoveryQos
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup2Deferred> lookup(
			String[] domains,
			String interfaceName,
			DiscoveryQos discoveryQos,
			String[] gbids
	);

	/**
	 * lookup
	 * @param participantId the parameter participantId
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup3Deferred> lookup(
			String participantId
	);

	/**
	 * lookup
	 * @param participantId the parameter participantId
	 * @param discoveryQos the parameter discoveryQos
	 * @param gbids the parameter gbids
	 * @return promise for asynchronous handling
	 */
	public Promise<Lookup4Deferred> lookup(
			String participantId,
			DiscoveryQos discoveryQos,
			String[] gbids
	);

	/**
	 * remove
	 * @param participantId the parameter participantId
	 * @return promise for asynchronous handling
	 */
	public Promise<DeferredVoid> remove(
			String participantId
	);

	public class Add1Deferred extends AbstractDeferred {
		public synchronized boolean resolve() {
			Object[] values = new Object[] {};
			return super.resolve(values);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class AddToAllDeferred extends AbstractDeferred {
		public synchronized boolean resolve() {
			Object[] values = new Object[] {};
			return super.resolve(values);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class Lookup1Deferred extends AbstractDeferred {
		public synchronized boolean resolve(DiscoveryEntryWithMetaInfo[] result) {
			return super.resolve((Object)result);
		}
	}

	public class Lookup2Deferred extends AbstractDeferred {
		public synchronized boolean resolve(DiscoveryEntryWithMetaInfo[] result) {
			return super.resolve((Object)result);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}

	public class Lookup3Deferred extends AbstractDeferred {
		public synchronized boolean resolve(DiscoveryEntryWithMetaInfo result) {
			return super.resolve(result);
		}
	}

	public class Lookup4Deferred extends AbstractDeferred {
		public synchronized boolean resolve(DiscoveryEntryWithMetaInfo result) {
			return super.resolve(result);
		}
		public synchronized boolean reject(joynr.types.DiscoveryError error) {
			return super.reject(new ApplicationException(error));
		}
	}
}
