/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.system;

import io.joynr.dispatcher.rpc.annotation.JoynrRpcBroadcast;
import io.joynr.dispatcher.rpc.JoynrBroadcastSubscriptionInterface;
import io.joynr.exceptions.SubscriptionException;
import io.joynr.proxy.Future;
import io.joynr.pubsub.subscription.BroadcastSubscriptionListener;
import joynr.OnChangeSubscriptionQos;
import joynr.BroadcastFilterParameters;


public interface MessageNotificationBroadcastInterface extends JoynrBroadcastSubscriptionInterface, MessageNotification {


public interface MessageQueuedForDeliveryBroadcastListener extends BroadcastSubscriptionListener {
	public void onReceive(String participantId, String messageType);
}

public class MessageQueuedForDeliveryBroadcastAdapter implements MessageQueuedForDeliveryBroadcastListener {
	public void onReceive(String participantId, String messageType) {
		// empty implementation
	}
	public void onError(SubscriptionException error) {
		// empty implementation
	}
	public void onSubscribed(String subscriptionId) {
		// empty implementation
	}
}

public class MessageQueuedForDeliveryBroadcastFilterParameters extends BroadcastFilterParameters {
	public MessageQueuedForDeliveryBroadcastFilterParameters() {};

	public MessageQueuedForDeliveryBroadcastFilterParameters(String participantId, String messageType) {
		super.setFilterParameter("participantId", participantId);
		super.setFilterParameter("messageType", messageType);
	}
	public void setParticipantId(String participantId) {
		super.setFilterParameter("participantId", participantId);
	}
	public String getParticipantId() {
		return super.getFilterParameter("participantId");
	}
	public void setMessageType(String messageType) {
		super.setFilterParameter("messageType", messageType);
	}
	public String getMessageType() {
		return super.getFilterParameter("messageType");
	}
}

@JoynrRpcBroadcast(broadcastName = "messageQueuedForDelivery")
abstract Future<String> subscribeToMessageQueuedForDeliveryBroadcast(
		MessageQueuedForDeliveryBroadcastListener broadcastListener,
		OnChangeSubscriptionQos subscriptionQos,
		MessageQueuedForDeliveryBroadcastFilterParameters filterParameters);

@JoynrRpcBroadcast(broadcastName = "messageQueuedForDelivery")
abstract Future<String> subscribeToMessageQueuedForDeliveryBroadcast(
		String subscriptionId,
		MessageQueuedForDeliveryBroadcastListener broadcastListener,
		OnChangeSubscriptionQos subscriptionQos,
		MessageQueuedForDeliveryBroadcastFilterParameters filterParameters);

abstract void unsubscribeFromMessageQueuedForDeliveryBroadcast(String subscriptionId);
}
