		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.system.RoutingTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.system.RoutingTypes.LocalAddress;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * BinderAddress client address
 */
@SuppressWarnings("serial")
public class BinderAddress extends LocalAddress implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("packageName")
	private String packageName;
	@JsonProperty("userId")
	private Integer userId;

	/**
	 * Default Constructor
	 */
	public BinderAddress() {
		this.packageName = "";
		this.userId = 0;
	}

	/**
	 * Copy constructor
	 *
	 * @param binderAddressObj reference to the object to be copied
	 */
	public BinderAddress(BinderAddress binderAddressObj) {
		super(binderAddressObj);
		this.packageName = binderAddressObj.packageName;
		this.userId = binderAddressObj.userId;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param packageName BinderAddress package name
	 * @param userId BinderAddress process user ID
	 */
	public BinderAddress(
		String packageName,
		Integer userId
		) {
		super(
		);
		this.packageName = packageName;
		this.userId = userId;
	}

	/**
	 * Gets PackageName
	 *
	 * @return BinderAddress package name
	 */
	@JsonIgnore
	public String getPackageName() {
		return packageName;
	}

	/**
	 * Sets PackageName
	 *
	 * @param packageName BinderAddress package name
	 */
	@JsonIgnore
	public void setPackageName(String packageName) {
		if (packageName == null) {
			throw new IllegalArgumentException("setting packageName to null is not allowed");
		}
		this.packageName = packageName;
	}

	/**
	 * Gets UserId
	 *
	 * @return BinderAddress process user ID
	 */
	@JsonIgnore
	public Integer getUserId() {
		return userId;
	}

	/**
	 * Sets UserId
	 *
	 * @param userId BinderAddress process user ID
	 */
	@JsonIgnore
	public void setUserId(Integer userId) {
		if (userId == null) {
			throw new IllegalArgumentException("setting userId to null is not allowed");
		}
		this.userId = userId;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "BinderAddress ["
		+ super.toString() + ", "
		+ "packageName=" + this.packageName + ", "
		+ "userId=" + this.userId
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		BinderAddress other = (BinderAddress) obj;
		if (this.packageName == null) {
			if (other.packageName != null) {
				return false;
			}
		} else if (!this.packageName.equals(other.packageName)){
			return false;
		}
		if (this.userId == null) {
			if (other.userId != null) {
				return false;
			}
		} else if (!this.userId.equals(other.userId)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.packageName == null) ? 0 : this.packageName.hashCode());
		result = prime * result + ((this.userId == null) ? 0 : this.userId.hashCode());
		return result;
	}
}

	
