		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.types;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.types.ProviderQos;
import joynr.types.Version;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * Stores information about a provider instance and is used to communicate capabilities between a cluster controller and a lib-joynr instance.
 */
@SuppressWarnings("serial")
public class DiscoveryEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("providerVersion")
	private Version providerVersion;
	@JsonProperty("domain")
	private String domain;
	@JsonProperty("interfaceName")
	private String interfaceName;
	@JsonProperty("participantId")
	private String participantId;
	@JsonProperty("qos")
	private ProviderQos qos;
	@JsonProperty("lastSeenDateMs")
	private Long lastSeenDateMs;
	@JsonProperty("expiryDateMs")
	private Long expiryDateMs;
	@JsonProperty("publicKeyId")
	private String publicKeyId;

	/**
	 * Default Constructor
	 */
	public DiscoveryEntry() {
		this.providerVersion = new Version();
		this.domain = "";
		this.interfaceName = "";
		this.participantId = "";
		this.qos = new ProviderQos();
		this.lastSeenDateMs = 0L;
		this.expiryDateMs = 0L;
		this.publicKeyId = "";
	}

	/**
	 * Copy constructor
	 *
	 * @param discoveryEntryObj reference to the object to be copied
	 */
	public DiscoveryEntry(DiscoveryEntry discoveryEntryObj) {
		this.providerVersion = new Version(discoveryEntryObj.providerVersion);
		this.domain = discoveryEntryObj.domain;
		this.interfaceName = discoveryEntryObj.interfaceName;
		this.participantId = discoveryEntryObj.participantId;
		this.qos = new ProviderQos(discoveryEntryObj.qos);
		this.lastSeenDateMs = discoveryEntryObj.lastSeenDateMs;
		this.expiryDateMs = discoveryEntryObj.expiryDateMs;
		this.publicKeyId = discoveryEntryObj.publicKeyId;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param providerVersion semantic version information
	 * @param domain the domain to register the provider with
	 * @param interfaceName the name of the provider interface
	 * @param participantId the participant ID of the provider
	 * @param qos the qos of the provider
	 * @param lastSeenDateMs the date in millis since epoch when the source for this provider last contacted the directory
	 * @param expiryDateMs the date in millis since epoch when this entry can be purged from the directory and caches
	 * @param publicKeyId the ID of the public key to be used to encrypt messages to this provider
	 */
	public DiscoveryEntry(
		Version providerVersion,
		String domain,
		String interfaceName,
		String participantId,
		ProviderQos qos,
		Long lastSeenDateMs,
		Long expiryDateMs,
		String publicKeyId
		) {
		this.providerVersion = providerVersion;
		this.domain = domain;
		this.interfaceName = interfaceName;
		this.participantId = participantId;
		this.qos = qos;
		this.lastSeenDateMs = lastSeenDateMs;
		this.expiryDateMs = expiryDateMs;
		this.publicKeyId = publicKeyId;
	}

	/**
	 * Gets ProviderVersion
	 *
	 * @return semantic version information
	 */
	@JsonIgnore
	public Version getProviderVersion() {
		return providerVersion;
	}

	/**
	 * Sets ProviderVersion
	 *
	 * @param providerVersion semantic version information
	 */
	@JsonIgnore
	public void setProviderVersion(Version providerVersion) {
		if (providerVersion == null) {
			throw new IllegalArgumentException("setting providerVersion to null is not allowed");
		}
		this.providerVersion = providerVersion;
	}

	/**
	 * Gets Domain
	 *
	 * @return the domain to register the provider with
	 */
	@JsonIgnore
	public String getDomain() {
		return domain;
	}

	/**
	 * Sets Domain
	 *
	 * @param domain the domain to register the provider with
	 */
	@JsonIgnore
	public void setDomain(String domain) {
		if (domain == null) {
			throw new IllegalArgumentException("setting domain to null is not allowed");
		}
		this.domain = domain;
	}

	/**
	 * Gets InterfaceName
	 *
	 * @return the name of the provider interface
	 */
	@JsonIgnore
	public String getInterfaceName() {
		return interfaceName;
	}

	/**
	 * Sets InterfaceName
	 *
	 * @param interfaceName the name of the provider interface
	 */
	@JsonIgnore
	public void setInterfaceName(String interfaceName) {
		if (interfaceName == null) {
			throw new IllegalArgumentException("setting interfaceName to null is not allowed");
		}
		this.interfaceName = interfaceName;
	}

	/**
	 * Gets ParticipantId
	 *
	 * @return the participant ID of the provider
	 */
	@JsonIgnore
	public String getParticipantId() {
		return participantId;
	}

	/**
	 * Sets ParticipantId
	 *
	 * @param participantId the participant ID of the provider
	 */
	@JsonIgnore
	public void setParticipantId(String participantId) {
		if (participantId == null) {
			throw new IllegalArgumentException("setting participantId to null is not allowed");
		}
		this.participantId = participantId;
	}

	/**
	 * Gets Qos
	 *
	 * @return the qos of the provider
	 */
	@JsonIgnore
	public ProviderQos getQos() {
		return qos;
	}

	/**
	 * Sets Qos
	 *
	 * @param qos the qos of the provider
	 */
	@JsonIgnore
	public void setQos(ProviderQos qos) {
		if (qos == null) {
			throw new IllegalArgumentException("setting qos to null is not allowed");
		}
		this.qos = qos;
	}

	/**
	 * Gets LastSeenDateMs
	 *
	 * @return the date in millis since epoch when the source for this provider last contacted the directory
	 */
	@JsonIgnore
	public Long getLastSeenDateMs() {
		return lastSeenDateMs;
	}

	/**
	 * Sets LastSeenDateMs
	 *
	 * @param lastSeenDateMs the date in millis since epoch when the source for this provider last contacted the directory
	 */
	@JsonIgnore
	public void setLastSeenDateMs(Long lastSeenDateMs) {
		if (lastSeenDateMs == null) {
			throw new IllegalArgumentException("setting lastSeenDateMs to null is not allowed");
		}
		this.lastSeenDateMs = lastSeenDateMs;
	}

	/**
	 * Gets ExpiryDateMs
	 *
	 * @return the date in millis since epoch when this entry can be purged from the directory and caches
	 */
	@JsonIgnore
	public Long getExpiryDateMs() {
		return expiryDateMs;
	}

	/**
	 * Sets ExpiryDateMs
	 *
	 * @param expiryDateMs the date in millis since epoch when this entry can be purged from the directory and caches
	 */
	@JsonIgnore
	public void setExpiryDateMs(Long expiryDateMs) {
		if (expiryDateMs == null) {
			throw new IllegalArgumentException("setting expiryDateMs to null is not allowed");
		}
		this.expiryDateMs = expiryDateMs;
	}

	/**
	 * Gets PublicKeyId
	 *
	 * @return the ID of the public key to be used to encrypt messages to this provider
	 */
	@JsonIgnore
	public String getPublicKeyId() {
		return publicKeyId;
	}

	/**
	 * Sets PublicKeyId
	 *
	 * @param publicKeyId the ID of the public key to be used to encrypt messages to this provider
	 */
	@JsonIgnore
	public void setPublicKeyId(String publicKeyId) {
		if (publicKeyId == null) {
			throw new IllegalArgumentException("setting publicKeyId to null is not allowed");
		}
		this.publicKeyId = publicKeyId;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "DiscoveryEntry ["
		+ "providerVersion=" + this.providerVersion + ", "
		+ "domain=" + this.domain + ", "
		+ "interfaceName=" + this.interfaceName + ", "
		+ "participantId=" + this.participantId + ", "
		+ "qos=" + this.qos + ", "
		+ "lastSeenDateMs=" + this.lastSeenDateMs + ", "
		+ "expiryDateMs=" + this.expiryDateMs + ", "
		+ "publicKeyId=" + this.publicKeyId
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DiscoveryEntry other = (DiscoveryEntry) obj;
		if (this.providerVersion == null) {
			if (other.providerVersion != null) {
				return false;
			}
		} else if (!this.providerVersion.equals(other.providerVersion)){
			return false;
		}
		if (this.domain == null) {
			if (other.domain != null) {
				return false;
			}
		} else if (!this.domain.equals(other.domain)){
			return false;
		}
		if (this.interfaceName == null) {
			if (other.interfaceName != null) {
				return false;
			}
		} else if (!this.interfaceName.equals(other.interfaceName)){
			return false;
		}
		if (this.participantId == null) {
			if (other.participantId != null) {
				return false;
			}
		} else if (!this.participantId.equals(other.participantId)){
			return false;
		}
		if (this.qos == null) {
			if (other.qos != null) {
				return false;
			}
		} else if (!this.qos.equals(other.qos)){
			return false;
		}
		if (this.lastSeenDateMs == null) {
			if (other.lastSeenDateMs != null) {
				return false;
			}
		} else if (!this.lastSeenDateMs.equals(other.lastSeenDateMs)){
			return false;
		}
		if (this.expiryDateMs == null) {
			if (other.expiryDateMs != null) {
				return false;
			}
		} else if (!this.expiryDateMs.equals(other.expiryDateMs)){
			return false;
		}
		if (this.publicKeyId == null) {
			if (other.publicKeyId != null) {
				return false;
			}
		} else if (!this.publicKeyId.equals(other.publicKeyId)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = 1;
		final int prime = 31;
		result = prime * result + ((this.providerVersion == null) ? 0 : this.providerVersion.hashCode());
		result = prime * result + ((this.domain == null) ? 0 : this.domain.hashCode());
		result = prime * result + ((this.interfaceName == null) ? 0 : this.interfaceName.hashCode());
		result = prime * result + ((this.participantId == null) ? 0 : this.participantId.hashCode());
		result = prime * result + ((this.qos == null) ? 0 : this.qos.hashCode());
		result = prime * result + ((this.lastSeenDateMs == null) ? 0 : this.lastSeenDateMs.hashCode());
		result = prime * result + ((this.expiryDateMs == null) ? 0 : this.expiryDateMs.hashCode());
		result = prime * result + ((this.publicKeyId == null) ? 0 : this.publicKeyId.hashCode());
		return result;
	}
}

	
